package de.duehl.swing.ui.highlightingeditor.unused;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class EditorCaretListener implements CaretListener {

    private final JTextPane editor;
    private final JScrollPane scroll;
    private final Document document;
    private final JScrollBar verticalScroll;

    /** Letzte "aktuelle" Zeile um zu viele Bewegungen der Scrollbar zu vermeiden... */
    private int lastLine = -1;

    private int caretPosition;
    private int currentLine;
    private boolean reactOnChanges;

    public EditorCaretListener(JTextPane editor, JScrollPane scroll) {
        this.editor = editor;
        this.scroll = scroll;

        doNotReactOnChanges();

        document = editor.getDocument();
        verticalScroll = scroll.getVerticalScrollBar();
    }

    public void reactOnChanges() {
        reactOnChanges = true;
    }

    public void doNotReactOnChanges() {
        reactOnChanges = false;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (reactOnChanges) {
            doCaretUpdate();
        }
    }

    private void doCaretUpdate() {
        caretPosition = editor.getCaretPosition();

        Element root = document.getDefaultRootElement();
        currentLine = root.getElementIndex(caretPosition);

        if (lastLine != currentLine) {
            lastLine = currentLine;
            reallyUpdate();
        }
    }

    private void reallyUpdate() {
        int startPosition = document.getStartPosition().getOffset();
        int endPosition = document.getEndPosition().getOffset();
        System.out.println("------------------------------------");
        System.out.println("startPosition =  " + startPosition);
        System.out.println("endPosition =  " + endPosition);

        System.out.println("caretPosition =  " + caretPosition);
        System.out.println("Bin in Zeile " + currentLine);

        /*
         * Die folgende Berechnung ist leider nicht absolut akkurat, sie wäre es,
         * gäbe es keine umbegrochenen Zeilen.
         */

        /*
         * TODO:
         * Vielleicht kann man irgendwie aus dem Dokument ermitteln, wie oft eine Zeile
         * gewrappt ist? Dann könnte man die Berechnung akkurat durchführen!
         *
         * Siehe getTextLineNumber in TextLineNumber und dessen Verwendung?
         *
         *
         *
         * TODO:
         * Außerdem muss man, bevor man die vertikale Scrollbar verändert, feststellen, ob die
         * Caretposition sichtbar ist. Wenn ja, sollte nichts geändert werden.
         */

        int minimum = verticalScroll.getMinimum();
        int maximum = verticalScroll.getMaximum();

        float caretFromStart = caretPosition - startPosition;
        float endFromStart = endPosition - startPosition;
        float maxFromMin = maximum - minimum;
        double x = minimum + (caretFromStart / endFromStart) * maxFromMin;
        int verticalValue = (int) x;
        scroll.getVerticalScrollBar().setValue(verticalValue);
    }

}
