package de.duehl.swing.ui.highlightingeditor.unused;

import java.awt.Color;
import java.awt.Graphics2D;

import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.Painter;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

/**
 * Sacht erweiterte JTextPane.
 *
 * Da das NimbusLookAndFeel ein einfaches
 *     editor.setBackground(new Color(220, 220, 220));
 * unterwandert und der Hintergrund weiß bleibt, muss diese Klasse verwendet werden.
 *
 * Siehe https://stackoverflow.com/questions/14700758/
 *               how-to-change-background-color-for-nimbus-look-and-feel-using-java
 *
 * @version 1.01     2017-12-07
 * @author Christian Dühl
 */

public class JTextPaneWithNimbusLookAndFeelBackgroundColor extends JTextPane {

    private static final long serialVersionUID = 1L;

    public JTextPaneWithNimbusLookAndFeelBackgroundColor(Color background) {
        setBackground(background);
    }

    @Override
    public void updateUI() {
        if ("Nimbus".equals(UIManager.getLookAndFeel().getName())) {
            UIDefaults map = new UIDefaults();
            Painter<JComponent> painter = new Painter<JComponent>() {
                @Override
                public void paint(Graphics2D g, JComponent c, int w, int h) {
                    g.setColor(getBackground());
                    g.fillRect(0, 0, w, h);
                }
            };
            map.put("DesktopPane[Enabled].backgroundPainter", painter);
            putClientProperty("Nimbus.Overrides", map);
        }
        super.updateUI();
    }

}
