package de.duehl.swing.ui.key;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.KeyStroke;

/**
 * Diese Klasse stellt Konstanten rund um die Belegung von Tastaturbefehlen für einen Dialog oder
 * Frame zur Verfügung. Dazu gehören bestimmte Strings und zugehörige Keystrokes.
 *
 * @version 1.01     2025-07-08
 * @author Christian Dühl
 */

public class KeybingingDefinitions {

    public static final String KEYBINDING_ESCAPE = "ESCAPE";
    public static final String KEYBINDING_POS1 = "HOME";
    public static final String KEYBINDING_END = "END";
    public static final String KEYBINDING_CTRL_POS1 = "CTRL_HOME";
    public static final String KEYBINDING_CTRL_END = "CTRL_END";
    public static final String KEYBINDING_PAGE_UP = "PAGE_UP";
    public static final String KEYBINDING_PAGE_DOWN = "PAGE_DOWN";
    public static final String KEYBINDING_ENTER = "ENTER";
    public static final String KEYBINDING_CTRL_ENTER = "CTRL_ENTER";

    public static final String KEYBINDING_F1 = "F1";
    public static final String KEYBINDING_F2 = "F2";
    public static final String KEYBINDING_F3 = "F3";
    public static final String KEYBINDING_F4 = "F4";
    public static final String KEYBINDING_F5 = "F5";
    public static final String KEYBINDING_F6 = "F6";
    public static final String KEYBINDING_F7 = "F7";
    public static final String KEYBINDING_F8 = "F8";
    public static final String KEYBINDING_F9 = "F9";
    public static final String KEYBINDING_F10 = "F10";
    public static final String KEYBINDING_F11 = "F11";
    public static final String KEYBINDING_F12 = "F12";

    public static final String KEYBINDING_LEFT = "LEFT";
    public static final String KEYBINDING_RIGHT = "RIGHT";
    public static final String KEYBINDING_UP = "UP";
    public static final String KEYBINDING_DOWN = "DOWN";

    public static final String KEYBINDING_CTRL_LEFT = "CTRL_LEFT";
    public static final String KEYBINDING_CTRL_RIGHT = "CTRL_RIGHT";
    public static final String KEYBINDING_CTRL_UP = "CTRL_UP";
    public static final String KEYBINDING_CTRL_DOWN = "CTRL_DOWN";

    public static final String KEYBINDING_ALT_LEFT = "ALT_LEFT";
    public static final String KEYBINDING_ALT_RIGHT = "ALT_RIGHT";
    public static final String KEYBINDING_ALT_UP = "ALT_UP";
    public static final String KEYBINDING_ALT_DOWN = "ALT_DOWN";

    public static final String KEYBINDING_TABULATOR = "TABULATOR";
    public static final String KEYBINDING_DELETE = "DELETE";
    public static final String KEYBINDING_INSERT = "INSERT";

    public static final String KEYBINDING_NUMPAD_PLUS = "NUMPAD_PLUS";
    public static final String KEYBINDING_NUMPAD_MINUS = "NUMPAD_MINUS";

    public static final int KEYEVENT_ESCAPE = KeyEvent.VK_ESCAPE;
    public static final int KEYEVENT_POS1 = KeyEvent.VK_HOME;
    public static final int KEYEVENT_END = KeyEvent.VK_END;
    public static final int KEYEVENT_PAGE_UP = KeyEvent.VK_PAGE_UP;
    public static final int KEYEVENT_PAGE_DOWN = KeyEvent.VK_PAGE_DOWN;
    public static final int KEYEVENT_ENTER = KeyEvent.VK_ENTER;

    public static final int KEYEVENT_F1 = KeyEvent.VK_F1;
    public static final int KEYEVENT_F2 = KeyEvent.VK_F2;
    public static final int KEYEVENT_F3 = KeyEvent.VK_F3;
    public static final int KEYEVENT_F4 = KeyEvent.VK_F4;
    public static final int KEYEVENT_F5 = KeyEvent.VK_F5;
    public static final int KEYEVENT_F6 = KeyEvent.VK_F6;
    public static final int KEYEVENT_F7 = KeyEvent.VK_F7;
    public static final int KEYEVENT_F8 = KeyEvent.VK_F8;
    public static final int KEYEVENT_F9 = KeyEvent.VK_F9;
    public static final int KEYEVENT_F10 = KeyEvent.VK_F10;
    public static final int KEYEVENT_F11 = KeyEvent.VK_F11;
    public static final int KEYEVENT_F12 = KeyEvent.VK_F12;

    public static final int KEYEVENT_LEFT = KeyEvent.VK_LEFT;
    public static final int KEYEVENT_RIGTH = KeyEvent.VK_RIGHT;
    public static final int KEYEVENT_UP = KeyEvent.VK_UP;
    public static final int KEYEVENT_DOWN = KeyEvent.VK_DOWN;

    public static final int KEYEVENT_TABULATOR = KeyEvent.VK_TAB;
    public static final int KEYEVENT_DELETE = KeyEvent.VK_DELETE;
    public static final int KEYEVENT_INSERT = KeyEvent.VK_INSERT;

    public static final int KEYEVENT_NUMPAD_PLUS = KeyEvent.VK_ADD;
    public static final int KEYEVENT_NUMPAD_MINUS = KeyEvent.VK_SUBTRACT;

    public static final KeyStroke KEYSTROKE_ESCAPE = createUnmodifiedKeystroke(KEYEVENT_ESCAPE);
    public static final KeyStroke KEYSTROKE_POS1 = createUnmodifiedKeystroke(KEYEVENT_POS1);
    public static final KeyStroke KEYSTROKE_END = createUnmodifiedKeystroke(KEYEVENT_END);
    public static final KeyStroke KEYSTROKE_PAGE_UP = createUnmodifiedKeystroke(KEYEVENT_PAGE_UP);
    public static final KeyStroke KEYSTROKE_PAGE_DOWN = createUnmodifiedKeystroke(KEYEVENT_PAGE_DOWN);
    public static final KeyStroke KEYSTROKE_ENTER = createUnmodifiedKeystroke(KEYEVENT_ENTER);

    public static final KeyStroke KEYSTROKE_CTRL_POS1 = createCtrlKeystroke(KEYEVENT_POS1);
    public static final KeyStroke KEYSTROKE_CTRL_END = createCtrlKeystroke(KEYEVENT_END);
    public static final KeyStroke KEYSTROKE_CTRL_ENTER = createCtrlKeystroke(KEYEVENT_ENTER);

    public static final KeyStroke KEYSTROKE_F1 = createUnmodifiedKeystroke(KEYEVENT_F1);
    public static final KeyStroke KEYSTROKE_F2 = createUnmodifiedKeystroke(KEYEVENT_F2);
    public static final KeyStroke KEYSTROKE_F3 = createUnmodifiedKeystroke(KEYEVENT_F3);
    public static final KeyStroke KEYSTROKE_F4 = createUnmodifiedKeystroke(KEYEVENT_F4);
    public static final KeyStroke KEYSTROKE_F5 = createUnmodifiedKeystroke(KEYEVENT_F5);
    public static final KeyStroke KEYSTROKE_F6 = createUnmodifiedKeystroke(KEYEVENT_F6);
    public static final KeyStroke KEYSTROKE_F7 = createUnmodifiedKeystroke(KEYEVENT_F7);
    public static final KeyStroke KEYSTROKE_F8 = createUnmodifiedKeystroke(KEYEVENT_F8);
    public static final KeyStroke KEYSTROKE_F9 = createUnmodifiedKeystroke(KEYEVENT_F9);
    public static final KeyStroke KEYSTROKE_F10 = createUnmodifiedKeystroke(KEYEVENT_F10);
    public static final KeyStroke KEYSTROKE_F11 = createUnmodifiedKeystroke(KEYEVENT_F11);
    public static final KeyStroke KEYSTROKE_F12 = createUnmodifiedKeystroke(KEYEVENT_F12);

    public static final KeyStroke KEYSTROKE_LEFT = createUnmodifiedKeystroke(KEYEVENT_LEFT);
    public static final KeyStroke KEYSTROKE_RIGTH = createUnmodifiedKeystroke(KEYEVENT_RIGTH);
    public static final KeyStroke KEYSTROKE_UP = createUnmodifiedKeystroke(KEYEVENT_UP);
    public static final KeyStroke KEYSTROKE_DOWN = createUnmodifiedKeystroke(KEYEVENT_DOWN);

    public static final KeyStroke KEYSTROKE_CTRL_LEFT = createCtrlKeystroke(KEYEVENT_LEFT);
    public static final KeyStroke KEYSTROKE_CTRL_RIGTH = createCtrlKeystroke(KEYEVENT_RIGTH);
    public static final KeyStroke KEYSTROKE_CTRL_UP = createCtrlKeystroke(KEYEVENT_UP);
    public static final KeyStroke KEYSTROKE_CTRL_DOWN = createCtrlKeystroke(KEYEVENT_DOWN);

    public static final KeyStroke KEYSTROKE_ALT_LEFT = createCtrlKeystroke(KEYEVENT_LEFT);
    public static final KeyStroke KEYSTROKE_ALT_RIGTH = createCtrlKeystroke(KEYEVENT_RIGTH);
    public static final KeyStroke KEYSTROKE_ALT_UP = createCtrlKeystroke(KEYEVENT_UP);
    public static final KeyStroke KEYSTROKE_ALT_DOWN = createCtrlKeystroke(KEYEVENT_DOWN);

    public static final KeyStroke KEYSTROKE_TABULATOR = createUnmodifiedKeystroke(KEYEVENT_TABULATOR);
    public static final KeyStroke KEYSTROKE_DELETE = createUnmodifiedKeystroke(KEYEVENT_DELETE);
    public static final KeyStroke KEYSTROKE_INSERT = createUnmodifiedKeystroke(KEYEVENT_INSERT);

    public static final KeyStroke KEYSTROKE_NUMPAD_PLUS =
            createUnmodifiedKeystroke(KEYEVENT_NUMPAD_PLUS);
    public static final KeyStroke KEYSTROKE_NUMPAD_MINUS =
            createUnmodifiedKeystroke(KEYEVENT_NUMPAD_MINUS);


    private static KeyStroke createUnmodifiedKeystroke(int keyevent) {
        return KeyStroke.getKeyStroke(keyevent, 0);
    }

    private static KeyStroke createCtrlKeystroke(int keyevent) {
        return KeyStroke.getKeyStroke(keyevent, InputEvent.CTRL_DOWN_MASK);
    }

}
