package de.duehl.swing.ui.menu.collection.tools;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.event.InputEvent;

/**
 * Diese Hilfsklasse erzeugt eine lesbare Darstellung von Modifikatoren eines Tastaturkommandos.
 *
 * @version 1.01     2020-07-08
 * @author Christian Dühl
 */

class ReadableModifiersGenerator {

    private final int modifiers;

    public ReadableModifiersGenerator(int modifiers) {
        this.modifiers = modifiers;
    }

    public String generate() {
        String modifierDescription = InputEvent.getModifiersExText(modifiers);
        modifierDescription = modifierDescription.replace("+", " + ");
        return modifierDescription;
    }

}
