package de.duehl.swing.ui.move.data;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse steht für eine "Gui", die nichts bewegt.
 *
 * @version 1.01     2025-08-07
 * @author Christian Dühl
 */

public class NotMovingGui<Bar> implements MovingGui<Bar> {

    /** Gibt an, ob die übergebene Bar nach oben bewegt werden kann. */
    @Override
    public boolean canBarMoveUp(Bar bar) {
        return false;
    }

    /** Gibt an, ob die übergebene Bar nach unten bewegt werden kann. */
    @Override
    public boolean canBarMoveDown(Bar bar) {
        return false;
    }

    /** Verschiebt die übergebene Bar an die erste Stelle. */
    @Override
    public void moveBarToFirst(Bar bar) {
        // nichts
    }

    /** Verschiebt die übergebene Bar nach oben. */
    @Override
    public void moveBarUp(Bar bar) {
        // nichts
    }

    /** Verschiebt die übergebene Bar nach unten. */
    @Override
    public void moveBarDown(Bar bar) {
        // nichts
    }

    /** Verschiebt die übergebene Bar an die letzte Stelle. */
    @Override
    public void moveBarToLast(Bar bar) {
        // nichts
    }

}
