package de.duehl.swing.ui.tabs.elements;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

import de.duehl.swing.ui.highlightingeditor.HighlightingEditor;
import de.duehl.swing.ui.tabs.Tabulator;

/**
 * Diese Klasse enthält alle Komponenten, die zu einem Reiter gehören mit einem Editor darin.
 *
 * @version 1.01     2017-11-22
 * @author Christian Dühl
 */

public class TabElementsWithEditor extends TabElements<Component> {

    /** Editor, der im Hauptteil des Reiters angezeigt wird. */
    private final HighlightingEditor editor;

    /**
     * Konstruktor.
     *
     * @param title
     *            Titel des Reiters.
     * @param tabulator
     *            Objekt das oben im Reiter des Tabulators angezeigt wird.
     * @param editor
     *            Editor, der im Hauptteil des Reiters angezeigt wird.
     */
    public TabElementsWithEditor(String title, Tabulator tabulator, HighlightingEditor editor) {
        super(title, tabulator, editor.getComponent());
        this.editor = editor;
    }

    /** Getter für den Editor, der im Hauptteil des Reiters angezeigt wird. */
    public HighlightingEditor getEditor() {
        return editor;
    }


}
