package de.duehl.swing.ui.timer;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt die abstrakte Basis einer Klasse dar, die einen Timer für grafische
 * Oberflächen verwendet, der abläuft, bevor auf Usereingaben reagiert wird, damit der Benutzer in
 * Ruhe tippen kann, ohne gestört zu werden.
 *
 * @version 1.01     2017-11-20
 * @author Christian Dühl
 */

public abstract class WaitingUserInputTimerOperator {

    /** Der Timer der auf die Benutzereingaben wartet. */
    private WaitingUserInputTimer timer;

    /** Anzahl der Millisekunden vor Durchführung der Aufgabe. */
    private long millisecondsBeforeAction;

    /**
     * Konstruktor.
     *
     * @param millisecondsBeforeAction
     *            Anzahl der Millisekunden vor Durchführung der Aufgabe.
     */
    public WaitingUserInputTimerOperator(long millisecondsBeforeAction) {
        this.millisecondsBeforeAction = millisecondsBeforeAction;
    }

    /** Beim ChangeListener wird 100ms gewartet, bevor Änderungen wirklich ausgeführt werden. */
    public void startTimer() {
        if (null == timer || timer.hasStopped()) {
            timer = new WaitingUserInputTimer(createRunnable(), millisecondsBeforeAction);
        }
        else {
            timer.restart();
        }
    }

    /** Erstellt die zu erledigende Aufgabe, nachdem der Benutzer aufgehört hat zu tippen. */
    protected abstract Runnable createRunnable();

    /** Beendet den Timer. */
    public void cancelTimer() {
        if (null != timer) {
            timer.cancel();
        }
    }

}
