package de.duehl.swing.ui.resources;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.awt.Image;

import org.junit.Test;

public class IconLoaderTest {

    @Test
    public void create() {
        IconLoader loader = new IconLoader(this.getClass(), "BILD_ZUM_PROGRAMM");
        assertNotNull(loader);
    }

    @Test (expected = RuntimeException.class)
    public void defineProgramImageAndFailLoadIt() {
        IconLoader loader = new IconLoader(this.getClass(), "BILD_ZUM_PROGRAMM");

        /*
         * Es wurde aber kein Bild unter dem Kürzel "BILD_ZUM_PROGRAMM" bekannt gemacht, also
         * knallt der folgende Aufruf:
         */
        loader.loadProgramIconImage();
    }

    @Test
    public void defineProgramImageAddAndLoadIt() {
        String programImageIdentifier = "BILD_ZUM_PROGRAMM";
        IconLoader loader = new IconLoader(this.getClass(), programImageIdentifier);

        String programImageName = "program_image.jpg";
        loader.addPictureIdentifier(programImageIdentifier, programImageName);

        Image programImage = loader.loadProgramIconImage();
        assertNotNull(programImage);
    }

    @Test
    public void defineNewFileImageAddAndLoadIt() {
        String programImageIdentifier = "BILD_ZUM_PROGRAMM";
        String newFileIdentifier = "NEW_FILE";

        IconLoader loader = new IconLoader(this.getClass(), programImageIdentifier);
        loader.addPictureIdentifier(programImageIdentifier, "program_image.jpg");
        loader.addPictureIdentifier(newFileIdentifier, "datei_neu.gif");

        Image newFileImage = loader.loadImage(newFileIdentifier);
        assertNotNull(newFileImage);
    }

    @Test (expected = RuntimeException.class)
    public void defineNotExistingFileImageAddAndFailLoadingIt() {
        String programImageIdentifier = "BILD_ZUM_PROGRAMM";
        String newFileIdentifier = "NEW_FILE";
        String loadFileIdentifier = "LOAD_FILE";

        IconLoader loader = new IconLoader(this.getClass(), programImageIdentifier);
        loader.addPictureIdentifier(programImageIdentifier, "program_image.jpg");
        loader.addPictureIdentifier(newFileIdentifier, "datei_neu.gif");

        loader.addPictureIdentifier(loadFileIdentifier, "datei_oeffnen.gif"); // ist in diesem
                                                                              // Verzeichnis nicht
                                                                              // da!

        loader.loadImage(loadFileIdentifier);
    }

}
