package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

import de.duehl.swing.ui.elements.progress.ColoredProgressBar;

public class ColoredProgressBarTest {

    private ColoredProgressBar bar;
    private JButton button;
    private int max = 4000;
    private int min = 0;

    public ColoredProgressBarTest() {

        bar = new ColoredProgressBar(min, max);
        bar.setValue(max);
        bar.setStringPainted(true);

        final Runnable runnable = new Runnable() {
            int rot = 0, gruen = 255;
            double faktor = max / 255 / 2;

            @Override
            public void run() {
                for (int i = max; i > min; i--) {
                    if (i < max / 5 * 2) {
                        rot += faktor / 5;
                    }
                    if (i < max / 10) {
                        gruen -= faktor / 25;
                        rot += faktor / 15;
                    }

                    rot = rot > 255 ? 255 : rot;
                    rot = rot < 0 ? 0 : rot;
                    gruen = gruen > 255 ? 255 : gruen;
                    gruen = gruen < 0 ? 0 : gruen;
                    bar.setForeground(new Color(rot, gruen, 0));
                    bar.setValue(i);
                    try {
                        Thread.sleep(5);
                    } catch (InterruptedException ex) {
                    }
                }
                rot = 0;
                gruen = 255;
            }
        };

        button = new JButton("start");
        button.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(runnable);
                thread.start();
            }
        });

        JFrame frame = new JFrame();
        frame.setLayout(new BorderLayout());
        frame.add(button, BorderLayout.SOUTH);
        frame.add(bar, BorderLayout.CENTER);

        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        new ColoredProgressBarTest();
    }
}