package de.duehl.swing.ui.start;

/*
 * Copyright 20?? Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;

import de.duehl.basics.system.SystemTools;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;

public class ProblemFrameIsNotQuitting extends NonModalFrameDialogBase {

    private static final Dimension WINDOW_DIMENSION = new Dimension(650, 500);

    public ProblemFrameIsNotQuitting() {
        super("Is NonModalFrameDialogBase closing?", WINDOW_DIMENSION);
        //addEscapeBehaviour(); // endet mit Escape. Aber nicht durch Klick auf das X
        //addClosingWindowListener(() -> closeDialog()); // damit endet er durch Klick auf das X!
        //addClosingWindowListener(() -> reallyClose()); // damit endet er durch Klick auf das X!
        //endLongTimeProcess(); // damit endet er durch Klick auf das X!

        fillDialog();

        /*
         * Das Problem liegt daran, dass der StopWatchLabel auf der GlassPane nicht beendet wird.
         */
    }

    @SuppressWarnings("unused")
    private void reallyClose() {
        boolean quit = GuiTools.askUser("Wirklich beenden", "Soll der Dialog beendet werden?");
        if (quit) {
            closeDialog();
        }
    }

    @Override
    protected void populateDialog() {
        useGlassPane(); // Danach beendet er sich auch!
    }

    //@SuppressWarnings("unused")
    private void useGlassPane() {
        startLongTimeProcess("Das dauert");
        new Thread(new Runnable() {
            @Override
            public void run() {
                SystemTools.sleepSeconds(5);
                endLongTimeProcess();
            }
        }).start();
    }

    public static void main(String[] args) {
        ProblemFrameIsNotQuitting frame = new ProblemFrameIsNotQuitting();
        frame.setVisible(true);
    }

}
