package de.duehl.swing.ui.start.filter.project.data;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;

/**
 * Diese Klasse stellt einen Datensatz der Testdaten für den Filter dar.
 *
 * Es handelt sich dabei um eine abgespeckte Version von
 *
 * de.heinsundpartner.hr.wz.application.logic.analyse.WZCodeCombinedData
 *
 * @version 1.01     2020-11-05
 * @author Christian Dühl
 */

public class TestFilterData {

    public static final String NOT_EDITED_WORKING_CODE = "-1";
    public static final String EDITED_WORKING_CODE = "3";

    /** Die DOKNR - die eindeutige Nummer des zugehörigen HR-Dokuments. */
    private final String doknr;

    /** Das Datum des Datensatzes. */
    private final String date;

    /** Der Name der Firma. */
    private final String companyName;

    /** Bearbeitungscode dieses Datensatzes. */
    private String workingCode;

    /** Objekt mit den Textteilen (Sätzen) und den Methoden zu deren Analyse. */
    private final List<String> textParts;

    /** Zeigt an, ob die Firma ein nonprofit Unternehmen ist. */
    private boolean nonprofit;

    /** Der Eintragstyp. */
    private EntryType entryType;

    /** Die WZ-Codes. */
    private List<String> wzCodes;

    /**
     * Der Konstruktor.
     *
     * @param doknr
     *            Die Doknummer des Datensatzes.
     * @param date
     *            Das Datum des Datensatzes.
     * @param textIn
     *            Die Sätze mit dem Gegenstandstext des Datensatzes.
     * @param companyName
     *            Der Firmenname des Datensatzes.
     */
    public TestFilterData(String doknr, String date, List<String> textParts, String companyName,
            String ... wzCodes) {
        this.doknr = doknr;
        this.date = date;
        this.textParts = textParts;
        this.companyName = companyName;
        this.wzCodes = CollectionsHelper.arrayToList(wzCodes);

        nonprofit = false;
        entryType = EntryType.NEUEINTRAG;
        workingCode = NOT_EDITED_WORKING_CODE;
    }

    /** Getter für die DOKNR. */
    public String getDoknr() {
        return doknr;
    }

    /** Getter für das Datum. */
    public String getDate() {
        return date;
    }

    /** Getter für den Text. */
    public List<String> getText() {
        return textParts;
    }

    /** Getter für den Firmennamen. */
    public String getCompanyName() {
        return companyName;
    }

    /** Getter für den non profit Flag. */
    public boolean isNonProfit() {
        return nonprofit;
    }

//    /** Setter für den non profit Flag. */
//    public void setNonProfit(boolean nonprofit) {
//        this.nonprofit = nonprofit;
//    }

    /** Getter für den Eintragstyp. */
    public EntryType getEntryType() {
        return entryType;
    }

//    /** Setter für den Eintragstyp. */
//    public void setEntryType(EntryType eintragsart) {
//        this.entryType = eintragsart;
//    }

//    /**
//     * Getter für einen Code. Der index muss gültig sein: 0 <= index < MAXIMAL_NUMBER_OF_CODES
//     *
//     * @param index
//     *            Der Index des gewünschten Datensatzes.
//     * @return Der Code
//     */
//    public String getCode(int index) {
//        return textParts.getCode(index);
//    }
//
//    /**
//     * Setter für einen Code. Der index muss gültig sein: 0 <= index < MAXIMAL_NUMBER_OF_CODES
//     *
//     * @param index
//     *            Der Index des gewünschten Datensatzes.
//     * @param code
//     *            Der Code.
//     */
//    public void setCode(int index, String code) {
//        textParts.setCode(index, code);
//    }

//    /** Getter für die Liste der Eintragstypvorschlag aus der Textanalyse. */
//    public List<String> getEntryGesses() {
//        return textParts.getEntryGesses();
//    }

//    /**
//     * Getter für die Treffer in den analysierten Texten als Liste von Treffer-Gruppen eines
//     * Satzes.
//     */
//    public List<HitGroups> getTextHitGroupsList() {
//        analyseIfNecessary();
//
//        List<HitGroups> list = new ArrayList<>();
//
//        for (HitGroups hitGroups : textParts.getHitGroupsList()) {
//            list.add(hitGroups);
//        }
//
//        return list;
//    }
//
//    /** Getter für die Treffer in den analysierten Texten. */
//    private List<Hit> getTextWzHits() {
//        analyseIfNecessary();
//
//        List<Hit> list = new ArrayList<>();
//        for (HitGroups hitGroups : textParts.getHitGroupsList()) {
//            for (HitGroup hitGroup : hitGroups) {
//                for (Hit hit : hitGroup) {
//                    list.add(hit);
//                }
//            }
//        }
//        return list;
//    }
//
//    /** Getter für die Anzahl der Treffer im Text. */
//    public int getNumberOfTextHits() {
//        return getTextWzHits().size();
//    }

//    /** Getter für die Treffer im Firmennamen. */
//    public HitGroups getCompanyNameWZHits() {
//        analyseIfNecessary();
//
//        return companyName.getHitGroups();
//    }
//
//    /** Getter für die Anzahl der Treffer im Firmennamen. */
//    public int getNumberOfNameHits() {
//        analyseIfNecessary();
//
//        List<Hit> list = new ArrayList<>();
//        for (HitGroup hitGroup : companyName.getHitGroups()) {
//            for (Hit hit : hitGroup) {
//                list.add(hit); // hat immer nur einen, aber das ist hier egal...
//            }
//        }
//        return list.size();
//    }

    /**
     * Getter für den Bearbeitungscode.
     *
     * @return Bearbeitungscode
     */
    public String getWorkingCode() {
        return workingCode;
    }

//    /**
//     * Setter für den Bearbeitungscode.
//     *
//     * @param workingCode
//     *            neuer Bearbeitungscode.
//     */
//    public void setWorkingCode(String workingCode) {
//        this.workingCode = workingCode;
//    }

//    /**
//     * Ermittelt, ob der ganze Eintrag bestehend aus allen Sätzen wohl bekannt ist, das heißt, dass
//     * alle Sätze leer oder als ganzes bekannt sind.
//     *
//     * @return true, wenn alle Sätze erschlossen wurden.
//     */
//    public boolean isWellKnown() {
//        analyseIfNecessary();
//        return textParts.isWellKnown();
//    }

//    /**
//     * Ermittelt, ob der ganze Eintrag bestehend aus allen Sätzen bis auf einen Satz wohl bekannt
//     * ist, das heißt, dass alle bis auf einen Satz leer oder als ganzes bekannt sind.
//     *
//     * @return true, wenn alle bis auf genau einen Satz erschlossen wurden.
//     */
//    public boolean isOneSentenceUnknown() {
//        analyseIfNecessary();
//        return textParts.isOneSentenceUnknown();
//    }

//    /**
//     * Ermittelt, ob der ganze Eintrag bestehend aus allen Sätzen bis auf einen kurzen Satz wohl
//     * bekannt ist, das heißt, dass alle bis auf einen (kurzen) Satz leer oder als ganzes bekannt
//     * sind.
//     *
//     * @param shortSentenceLength
//     *            Länge, bis zu der ein Satz als kurz gilt.
//     * @return true, wenn alle bis auf genau einen Satz erschlossen wurden.
//     */
//    public boolean isOneShortSentenceUnknown(int shortSentenceLength) {
//        analyseIfNecessary();
//        return textParts.isOneShortSentenceUnknown(shortSentenceLength);
//    }

    /** Getter für die WZ-Codes. */
    public List<String> getWzCodes() {
        return wzCodes;
    }

    @Override
    public String toString() {
        return "TestFilterData [doknr=" + doknr + ", date=" + date + ", companyName=" + companyName
                + ", workingCode=" + workingCode + ", textParts=" + textParts + ", nonprofit="
                + nonprofit + ", entryType=" + entryType + ", wzCodes=" + wzCodes + "]";
    }

}
