package de.duehl.swing.ui.start.filter.project.method;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

import de.duehl.swing.ui.filter.method.Method;
import de.duehl.swing.ui.start.filter.project.data.TestFilterData;
import de.duehl.swing.ui.start.filter.project.gateway.generics.GenericData2Concrete;

/**
 * Diese Klasse repräsentiert die Filtermethode 'Datensätze mit kurzen Texten'
 * (SHORT_TEXT).
 *
 * @version 1.01     2020-11-05
 * @author Christian Dühl
 */

public class TestMethodShortText<Data> implements Method<Data> {

    /** Länge, bis zu der bereinigte Sätze als "kurz" gelten. */
    private final int maximalSentenceLength = 100;

    /** Anzahl "kurzer" Sätze, die maximal vorkommen dürfen. */
    private final int maximalNumberOfSentences = 1;

    @Override
    public List<Integer> buildFilter(List<Data> list) {
        List<Integer> numberList = new ArrayList<Integer>();

        for (int index = 0; index < list.size(); ++index) {
            Data data = list.get(index);
            TestFilterData testFilterData = new GenericData2Concrete<Data>().generic2Concrete(data);

            int countSentences = 0;
            boolean isShort = true;
            for (String text : testFilterData.getText()) {
                if (text.length() > maximalSentenceLength) {
                    isShort = false;
                    break;
                }
                if (text.length() > 1) {
                    ++countSentences;
                    if (countSentences > maximalNumberOfSentences) {
                        isShort = false;
                        break;
                    }
                }
            }

            if (isShort) {
                numberList.add(index + 1);
            }
        }

        return numberList;
    }

}
