package de.duehl.swing.ui.start.size;

import java.awt.BorderLayout;
import java.awt.Dimension;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.elements.size.ChangeButtonWithSizeChooser;

/**
 * Diese Klasse testet den Dialog zur Auswahl einer Größe mit Button zum Ändern.
 *
 * @version 1.01     2020-11-03
 * @author Christian Dühl
 */

public class ChangeButtonWithSizeChooserTest extends NonModalFrameDialogBase {

    private static final Dimension DIALOG_DIMENSION = new Dimension(400, 200);

    private final ChangeButtonWithSizeChooser chooser;

    /** Konstruktor. */
    public ChangeButtonWithSizeChooserTest() {
        super("ChangeButtonWithSizeChooser Test", DIALOG_DIMENSION);

        int rows = 3;
        int columns = 5;
        List<Integer> possibleSizes = CollectionsHelper.buildListFrom(
                10, 11, 12, 13, 14,
                15, 16, 17, 18, 19,
                20, 22, 24, 32, 38
                );

        chooser = new ChangeButtonWithSizeChooser(getLocation(),
                "Schriftgröße", rows, columns, possibleSizes);
        chooser.setSize(16);
        chooser.differentSizesAreOk();

        fillDialog();
    }

    /** Baut die Gui auf. */
    @Override
    protected void populateDialog() {
        add(chooser.getSizeChangeButton(), BorderLayout.CENTER);
    }

    public static void main(String[] args) {
        GuiTools.setNiceLayoutManager();
        new ChangeButtonWithSizeChooserTest().setVisible(true);
    }

}
