package de.duehl.swing.ui.start.tabbars;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.tabs.bars.generic.GrowingTabBar;

/**
 * Diese Klasse testet die TabBar-Elemente.
 *
 * @version 1.01     2017-12-07
 * @author Christian Dühl
 */

public class GrowingTabBarTest {

    /** Die zu testenden Reiter. */
    private GrowingTabBar<JPanel> tabBar;

    /** Konstruktor. */
    public GrowingTabBarTest() {
        tabBar = new GrowingTabBar<>(title -> createNewTab(title));
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private void createNewTab(String title) {
        String notUsedTitle = tabBar.generateNotUsedTitle(title);

        JPanel tabContents = createNewTabPanel(notUsedTitle);
        tabBar.addTab(notUsedTitle, tabContents);
    }

    private JPanel createNewTabPanel(String title) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.LIGHT_GRAY);

        panel.add(new JLabel(title, JLabel.CENTER), BorderLayout.CENTER);

        return panel;
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("TabBar Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new GridLayout(0,  1));

        frame.add(fillTabBar());

        frame.setPreferredSize(new Dimension(800, 600));
        frame.pack();
        frame.setVisible(true);
    }

    private Component fillTabBar() {
        addTab("Äpfel" , Color.GREEN);
        addTab("Birnen" , Color.RED);
        addTab("Pflaumen" , Color.BLUE);

        return tabBar.getComponent();
    }

    private void addTab(String title, Color color) {
        JPanel panel = createPanel(color);
        tabBar.addTab(title, panel);
    }

    private JPanel createPanel(Color color) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(color);

        return panel;
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new GrowingTabBarTest();
    }

}

