package de.duehl.swing.ui.start.timedate;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.basics.datetime.date.Weekday;
import de.duehl.swing.ui.components.selections.datetime.WeekdaySelection;

public class WeekdaySelectionTest {

    private final WeekdaySelection weekdaySelection = new WeekdaySelection();

    public WeekdaySelectionTest() {
        SwingUtilities.invokeLater(this::createFrame);
    }

    private void createFrame() {
        JFrame frame= new JFrame();
        frame.setTitle("Testprogramm zum Wählen eines Wochentages.");

        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(weekdaySelection.getPanel(), BorderLayout.CENTER);
        frame.add(createPrintWeekdayButton(), BorderLayout.SOUTH);

        frame.pack();
        frame.setVisible(true);
    }

    private Component createPrintWeekdayButton() {
        JButton button = new JButton("Print");
        button.addActionListener(e -> printWeekday());
        return button;
    }

    private void printWeekday() {
        {
            String weekday = weekdaySelection.getText();
            System.out.println(weekday);
        }
        {
            Weekday weekday = weekdaySelection.getWeekday();
            System.out.println(weekday);
        }
        {
            int dayCode = weekdaySelection.getDayCode();
            System.out.println(Integer.toString(dayCode));
        }
    }

    public static void main(String[] args) {
        new WeekdaySelectionTest();
    }

}
