package de.duehl.swing.ui.start.trial;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;

import javax.swing.JLabel;
import javax.swing.JScrollPane;

import de.duehl.basics.io.FileHelper;
import de.duehl.swing.ui.components.elements.TitledList;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.dragndrop.file.FileDropTargetListener;
import de.duehl.swing.ui.text.TextPanel;

public class DragAndDropAFile extends NonModalFrameDialogBase {

    private static final Dimension WINDOW_DIMENSION = new Dimension(650, 500);

    private final JLabel dragTarget;
    private final TextPanel textPanel;
    private final TitledList filenameList;
    private final JScrollPane filenameScroll;

    public DragAndDropAFile() {
        super(null, "DragAndDropAFile - Test", WINDOW_DIMENSION);

        dragTarget = new JLabel("Drag something here!");

        filenameList = new TitledList("Liste der gedroppten Dateien");
        filenameScroll = new JScrollPane(filenameList.getPanel());

        textPanel = new TextPanel();
        textPanel.setPreferredSize(650, 200);

        enableFileDrag();

        fillDialog();
    }

    private void enableFileDrag() {
        FileDropTargetListener fileDropTargetListener = new FileDropTargetListener() {
            @Override
            protected void useFile(String filename) {
                filenameList.addValueToList(filename);
                filenameScroll.validate();
                readFile(filename);
            }
        };
        //new DropTarget(dragTarget, fileDropTargetListener);
        new DropTarget(getDialog(), fileDropTargetListener);
    }


    private void readFile(String filename) {
        textPanel.setText(FileHelper.readFileToString(filename));
    }

    @Override
    protected void populateDialog() {
        add(dragTarget, BorderLayout.NORTH);
        add(textPanel.getComponent(), BorderLayout.SOUTH);
        add(filenameScroll, BorderLayout.CENTER);
    }

    public static void main(String[] args) {
        DragAndDropAFile dialog = new DragAndDropAFile();
        dialog.setVisible(true);
    }

}
