package de.duehl.swing.ui.start.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingConstants;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.swing.ui.elements.watch.StopWatchLabel;

public class StopWatchLabelTest {

    public static void main(String[] args) {
        JFrame frame = new JFrame("StopWatchLabel Demo");
        frame.setLayout(new BorderLayout());

        String jobId = "JOB_20131206_235_Lauf_1_0017";
        String startText = "<html><center>" + jobId
        + "<br/>volume100017.xml"
        + "<br/>";
        String endText = "</center></html>";
        StopWatch stopWatch = new StopWatch();

        StopWatchLabel label = new StopWatchLabel(startText, stopWatch, endText);
        label.setHorizontalAlignment(SwingConstants.CENTER);
        label.setForeground(Color.RED);
        frame.add(label, BorderLayout.CENTER);

        JButton stopButton = new JButton("Stopp");
        stopButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                label.stop();
                label.setForeground(Color.BLACK);
            }
        });
        frame.add(stopButton, BorderLayout.EAST);

        JButton startButton = new JButton("Start");
        startButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                label.start();
                label.setForeground(Color.RED);
            }
        });
        frame.add(startButton, BorderLayout.WEST);

        frame.setSize(400, 100);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setVisible(true);
    }

}
