package de.duehl.threads.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.threads.VeryLongRegExpRunnable;
import de.duehl.threads.timed.TimedThreadRunner;
import de.duehl.threads.timed.TimedThreadRunner.TaskState;

public class TimedThreadRegExp1 {

    public static void main(String[] args) {
        int secondsBeforeKill = 10;
        int secondsBetweenWatching = 2;

        VeryLongRegExpRunnable runnable = new VeryLongRegExpRunnable();
        TimedThreadRunner runner = new TimedThreadRunner(secondsBeforeKill,
                1000L * secondsBetweenWatching, runnable);
        System.out.println("VOR runner.runTask()");
        runner.runTask();
        System.out.println("NACH runner.runTask()");
        TaskState state = runner.getTaskState();
        System.out.println("State : " + state);
    }

}

/*

VOR runner.runTask()
Prüfung zu Beginn in Ordnung.
- VeryLongRegExpRunnable gestartet
Warte 2 Sekunden...
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 10
    Bisher      : 2
Warte 2 Sekunden...
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 10
    Bisher      : 4
Warte 2 Sekunden...
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 10
    Bisher      : 6
Warte 2 Sekunden...
Abbruchzeit noch nicht erreicht:
    Abbruch nach: 10
    Bisher      : 8
Warte 2 Sekunden...
Zeit abgelaufen! Thread muss abgewürgt werden...
NACH runner.runTask()
State : CANCELLED

*/