package de.duehl.vocabulary.japanese.io;

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.data.Vocabulary;

/**
 * Diese Klasse verwaltet die Manuelle Sortierung der Liste der Bars zu den Vokabularien, welche in
 * der grafischen Oberfläche des Vokabel-Trainers dargestellt wird.
 *
 * Diese wird in einer benutzerspezifischen Datei abgelegt, die in jeder Zeile die Beschreibung
 * eines Vokabulars enthält.
 *
 * Gibt es die Beschreibung eines Vokabulars noch nicht in dieser Datei, so wird dieses am Ende
 * hinzugefügt.
 *
 * @version 1.01     2024-04-11
 * @author Christian Dühl
 */

public class ManualVocabularySortOrderFileIo {

    private static final String INTERNAL_SORT_ORDER_FILENAME = FileHelper.concatPathes(
            SessionManager.VOCABLE_TRAINER_DIRECTORY, "internal_vocabulary_sort_order.txt");

    private static final Charset CHARSET = Charset.UTF_8;

    /**
     * Liest die Beschreibungen der Vokabularien aus der benutzerspezifischen Datei ein.
     *
     * Falls die Datei nicht existiert, wird eine leere Liste zurückgegeben.
     */
    public static List<String> readManualVocabularyDescriptionsOrder() {
        if (FileHelper.isFile(INTERNAL_SORT_ORDER_FILENAME)) {
            return FileHelper.readFileToList(INTERNAL_SORT_ORDER_FILENAME, CHARSET);
        }
        else {
            return new ArrayList<>();
        }
    }

    /** Speichert die Beschreibungen der Vokabularien in die benutzerspezifische Datei. */
    public static void saveManualVocabularyOrder(List<Vocabulary> vocabularies) {
        List<String> descriptions = new ArrayList<>();
        for (Vocabulary vocabulary : vocabularies) {
            String descritpion = vocabulary.getDescription();
            descriptions.add(descritpion);
        }

        FileHelper.writeLinesToFile(descriptions, INTERNAL_SORT_ORDER_FILENAME, CHARSET);
    }

}
