package de.duehl.vocabulary.japanese.logic.symbol.kana.html;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.data.KanaStructure;

/**
 * Diese Klasse erzeugt HTML-Code mit einer Übersicht über die Hiragana.
 *
 * @version 1.01     2024-10-02
 * @author Christian Dühl
 */

public class HiraganaHtmlCreator {

    /** Die Struktur mit den Hiragana-Zeichen. */
    private KanaStructure structure;

    /** Der erzeugte HTML-Code. */
    private String html;

    /** Erzeugt den HTML-Code. */
    public void create() {
        createStructure();
        createKanaHtml();
    }

    private void createStructure() {
        structure = new KanaStructure();
        structure.fillAIUEO(
                Hiragana.A.toKana(),
                Hiragana.I.toKana(),
                Hiragana.U.toKana(),
                Hiragana.E.toKana(),
                Hiragana.O.toKana());
        structure.fillKaKiKuKeKo(
                Hiragana.KA.toKana(),
                Hiragana.KI.toKana(),
                Hiragana.KU.toKana(),
                Hiragana.KE.toKana(),
                Hiragana.KO.toKana());
        structure.fillSaShiSuSeSo(
                Hiragana.SA.toKana(),
                Hiragana.SHI.toKana(),
                Hiragana.SU.toKana(),
                Hiragana.SE.toKana(),
                Hiragana.SO.toKana());
        structure.fillTaChiTsuTeTo(
                Hiragana.TA.toKana(),
                Hiragana.CHI.toKana(),
                Hiragana.TSU.toKana(),
                Hiragana.TE.toKana(),
                Hiragana.TO.toKana());
        structure.fillNaNiNuNeNo(
                Hiragana.NA.toKana(),
                Hiragana.NI.toKana(),
                Hiragana.NU.toKana(),
                Hiragana.NE.toKana(),
                Hiragana.NO.toKana());
        structure.fillHaHiFuHeHo(
                Hiragana.HA.toKana(),
                Hiragana.HI.toKana(),
                Hiragana.FU.toKana(),
                Hiragana.HE.toKana(),
                Hiragana.HO.toKana());
        structure.fillMaMiMuMeMo(
                Hiragana.MA.toKana(),
                Hiragana.MI.toKana(),
                Hiragana.MU.toKana(),
                Hiragana.ME.toKana(),
                Hiragana.MO.toKana());
        structure.fillYaYuYo(
                Hiragana.YA.toKana(),
                Hiragana.YU.toKana(),
                Hiragana.YO.toKana());
        structure.fillRaRiRuReRo(
                Hiragana.RA.toKana(),
                Hiragana.RI.toKana(),
                Hiragana.RU.toKana(),
                Hiragana.RE.toKana(),
                Hiragana.RO.toKana());
        structure.fillWaWo(
                Hiragana.WA.toKana(),
                Hiragana.WO.toKana());
        structure.fillN(
                Hiragana.N.toKana());
        structure.fillGaGiGuGeGo(
                Hiragana.GA.toKana(),
                Hiragana.GI.toKana(),
                Hiragana.GU.toKana(),
                Hiragana.GE.toKana(),
                Hiragana.GO.toKana());
        structure.fillZaJiZuZeZo(
                Hiragana.ZA.toKana(),
                Hiragana.JI1.toKana(),
                Hiragana.ZU1.toKana(),
                Hiragana.ZE.toKana(),
                Hiragana.ZO.toKana());
        structure.fillDaJiZuDeDo(
                Hiragana.DA.toKana(),
                Hiragana.JI2.toKana(),
                Hiragana.ZU2.toKana(),
                Hiragana.DE.toKana(),
                Hiragana.DO.toKana());
        structure.fillBaBiBuBeBo(
                Hiragana.BA.toKana(),
                Hiragana.BI.toKana(),
                Hiragana.BU.toKana(),
                Hiragana.BE.toKana(),
                Hiragana.BO.toKana());
        structure.fillPaPiPuPePo(
                Hiragana.PA.toKana(),
                Hiragana.PI.toKana(),
                Hiragana.PU.toKana(),
                Hiragana.PE.toKana(),
                Hiragana.PO.toKana());

        structure.fillKyaKyuKyo(
                Hiragana.KYA.toKana(),
                Hiragana.KYU.toKana(),
                Hiragana.KYO.toKana());
        structure.fillShaShuSho(
                Hiragana.SHA.toKana(),
                Hiragana.SHU.toKana(),
                Hiragana.SHO.toKana());
        structure.fillChaChuCho(
                Hiragana.CHA.toKana(),
                Hiragana.CHU.toKana(),
                Hiragana.CHO.toKana());
        structure.fillNyaNyuNyo(
                Hiragana.NYA.toKana(),
                Hiragana.NYU.toKana(),
                Hiragana.NYO.toKana());
        structure.fillHyaHyuHyo(
                Hiragana.HYA.toKana(),
                Hiragana.HYU.toKana(),
                Hiragana.HYO.toKana());
        structure.fillMyaMyuMyo(
                Hiragana.MYA.toKana(),
                Hiragana.MYU.toKana(),
                Hiragana.MYO.toKana());
        structure.fillRyaRyuRyo(
                Hiragana.RYA.toKana(),
                Hiragana.RYU.toKana(),
                Hiragana.RYO.toKana());
        structure.fillGyaGyuGyo(
                Hiragana.GYA.toKana(),
                Hiragana.GYU.toKana(),
                Hiragana.GYO.toKana());
        structure.fillJaJuJo1(
                Hiragana.JA1.toKana(),
                Hiragana.JU1.toKana(),
                Hiragana.JO1.toKana());
        structure.fillJaJuJo2(
                Hiragana.JA2.toKana(),
                Hiragana.JU2.toKana(),
                Hiragana.JO2.toKana());
        structure.fillByaByuByo(
                Hiragana.BYA.toKana(),
                Hiragana.BYU.toKana(),
                Hiragana.BYO.toKana());
        structure.fillPyaPyuPyo(
                Hiragana.PYA.toKana(),
                Hiragana.PYU.toKana(),
                Hiragana.PYO.toKana());

        structure.fillKanaLehnworte(CollectionsHelper.buildListFrom(
                Hiragana.LEHNWORT_WI.toKana(),
                Hiragana.LEHNWORT_FA.toKana(),
                Hiragana.LEHNWORT_TI.toKana(),
                Hiragana.LEHNWORT_DU.toKana(),
                Hiragana.LEHNWORT_WE.toKana(),
                Hiragana.LEHNWORT_FO.toKana()
                ));

        structure.fillKleinesTsu(Hiragana.SMALL_TSU.toKana());
        structure.fillKleinesYaYuYoGo(
                Hiragana.SMALL_YA.toKana(),
                Hiragana.SMALL_YU.toKana(),
                Hiragana.SMALL_YO.toKana()
                );
    }

    private void createKanaHtml() {
        KanaHtmlCreator creator = new KanaHtmlCreator(structure, "Hiragana");
        creator.create();
        html = creator.getHtml();
    }

    /** Getter für den erzeugten HTML-Code. */
    public String getHtml() {
        return html;
    }

}
