package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JMenuBar;

import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2025-04-11
 * @author Christian Dühl
 */

public class MenuCreation {

    /** Verbindung zur Logik des Vokabel-Trainers. */
    private final VocabularyTrainerLogic logic;

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /** Das Menü. */
    private final JMenuBar menuBar;

    /**
     * Konstruktor.
     *
     * @param logic
     *            Verbindung zur Logik.
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public MenuCreation(VocabularyTrainerLogic logic, VocabularyTrainerGui gui) {
        this.logic = logic;
        this.gui = gui;
        menuBar = new JMenuBar();

        createTheMenu();
    }

    /** Erzeugt das Menü. */
    private void createTheMenu() {
        List<SingleMenuCreation> menues = new ArrayList<>();
        menues.add(new FileMenuCreation(logic));
        menues.add(new VocabularyMenuCreation(gui));
        menues.add(new VocableMenuCreation(gui));
        menues.add(new OwnListMenuCreation(gui));
        menues.add(new KanaAndKanjiMenuCreation(gui));
        menues.add(new GrammarMenuCreation(gui));
        menues.add(new ExtraMenuCreation(gui));
        menues.add(new UpdateMenuCreation(logic));
        menues.add(new HelpMenuCreation(gui));

        menuBar.removeAll();

        for (SingleMenuCreation menu : menues) {
            menuBar.add(menu.createTheMenu());
        }
    }

    /**
     * Trägt das Menü in einem JFrame ein.
     *
     * @param frame
     *            JFrame, bei dem das Menü eingetragen werden soll.
     */
    public void addTo(JFrame frame) {
        frame.setJMenuBar(menuBar);
        frame.validate();
    }

}
