package de.duehl.vocabulary.japanese.ui.dialog.detail.addtolist;

import java.awt.Image;
import java.awt.Point;

import javax.swing.JPanel;

import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;

/**
 * Diese Klasse stellt einen Button bereit, um die angezeigte Vokabel zu einer eigenen Liste
 * hinzuzufügen.
 *
 * @version 1.01     2025-07-14
 * @author Christian Dühl
 */

public class VocableToOwnListAdderGui {

    /** Fügt eine Vokabel zu einer eigenen Liste hinzu. */
    private final VocableToOwnListAdder vocableToOwnListAdder;

    /** Stellt den Button wirklich dar. */
    private final VocableToOwnListAdderButtonCreator creator;

    /**
     * Konstruktor.
     *
     * @param vocable
     *            Die angezeigte Vokabel.
     * @param ownLists
     *            Die Verwaltung der eigenen Vokabellisten.
     * @param location
     *            Die Position des Rahmens der Oberfläche, die den Panel anzeigt, welcher diese
     *            Klasse verwendet.
     * @param programImage
     *            Das Icon für das Programm.
     */
    public VocableToOwnListAdderGui(Vocable vocable, OwnLists ownLists, Point location,
            Image programImage) {
        vocableToOwnListAdder = new VocableToOwnListAdder(ownLists, location, programImage);
        creator = new VocableToOwnListAdderButtonCreator(vocable, vocableToOwnListAdder);
    }

    /**
     * Fügt zum übergebenen Panel einen Button zur Anzeige der eigenen Listen an, welche die
     * Vokabel enthalten.
     *
     * @param panel
     *            Der Panel dem die Buttons hinzugefügt werden sollen. Dieser sollte ein Layout
     *            haben, das das Hinzufügen von Elemente ohne weitere Parameter gestattet, wie z.B.
     *            das VerticalLayout.
     */
    public void appendButtonToPanel(JPanel panel) {
        panel.add(creator.createAddVocableToListButton());
    }

}
