package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components;

import java.awt.Color;

import javax.swing.JLabel;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;

/**
 * Diese Klasse stellt ein einzelnes Kanji-Zeichen (UTF-8) in einem Label dar.
 *
 * @version 1.01     2024-11-07
 * @author Christian Dühl
 */

public class KanjiLabel {

    private static final int DEFAULT_BIGGER_FONT_SIZE = 400;


    /** Die Vergrößerung der Schrift in der das Kanji dargestellt wird. */
    private int biggerFontSize;

    /** Das Label auf dem das Kanji dargestellt wird. */
    private final JLabel label;

    /** Gibt an, ob die Größe schon gesetzt wurde. */
    private boolean sizeSet;

    /** Konstruktor. */
    public KanjiLabel() {
        biggerFontSize = DEFAULT_BIGGER_FONT_SIZE;

        label = new JLabel();
        sizeSet = false;

        initLabel();
    }

    private void initLabel() {
        label.setOpaque(true);
        label.setBackground(Color.WHITE);
        label.setHorizontalAlignment(JLabel.CENTER);
        label.setVerticalAlignment(JLabel.CENTER);
    }

    /** Setter für die Vergrößerung der Schrift in der das Kanji dargestellt wird. */
    public void setBiggerFontSize(int biggerFontSize) {
        this.biggerFontSize = biggerFontSize;
    }

    /** Zeigt das Kanji an. Kann mehrfach aufgerufen werden. */
    public void showKanji(Kanji kanji) {
        setSizeIfNecessary();

        String kanjiCharacter = kanji.getCharacter();
        label.setText(kanjiCharacter);
    }

    private void setSizeIfNecessary() {
        if (!sizeSet) {
            GuiTools.biggerFont(label, biggerFontSize);
            sizeSet = true;
        }
    }

    /** Getter für das Label auf dem das Kanji dargestellt wird. */
    public JLabel getLabel() {
        return label;
    }

}
