package de.duehl.vocabulary.japanese.ui.dialog.table.vocable;

import de.duehl.swing.ui.tables.BasicTableColumnModel;
import de.duehl.vocabulary.japanese.common.persistence.Options;

/**
 * Diese Klasse stellt das Column-Modell der Tabelle mit den Vokabeln dar.
 *
 * @version 1.02     2025-06-27
 * @author Christian Dühl
 */

public class VocableTableColumnModel extends BasicTableColumnModel {

    private static final long serialVersionUID = 1L;


    /**
     * Die Tabelle enthält die folgenden Spalten:
     *     - laufende Nummer
     *     - kana
     *     - kanji
     *     - romaji
     *     - pronunciation
     *     - translation(s)
     *     - Button zum Abspielen der MP3-Datei
     *     - comment
     *     - Suchbegriffe
     *     - Wortarten
     *     - Beschreibung des Vokabulars aus dem die Vokabel stammt
     *     - testCount (data)
     *     - correctTestCount (data)
     *     - firstSeenDate (data)
     *     - lastTestDate (data)
     *     - lastCorrectTestDate (data)
     *     - lastTenTestResults (data)
     *     - Button zum Betrachten der Vokabel mit allen internen Daten
     * @param options
     *            Die Programmoptionen.
     */
    public VocableTableColumnModel(Options options) {
        addMinMaxWidthColumn(45, "#");
        addMinWidthColumn(90, "Kana");
        addMinWidthColumn(90, "Kanji");
        addMinWidthColumn(90, "Romaji");
        addMinWidthColumn(75, "Aussprache");
        addMinWidthColumn(90, "Übersetzung");
        addMinMaxWidthColumn(100, "Sound");
        addMinWidthColumn(75, "Bemerkung");
        addMinWidthColumn(75, "Suchbegriffe");
        addMinWidthColumn(75, "Wortarten");
        addMinWidthColumn(75, "Vokabular");
        addMinMaxWidthColumn(60, "Getestet");
        addMinMaxWidthColumn(50, "richtig");
        addMinMaxWidthColumn(90, "Bekannt seit");
        addMinMaxWidthColumn(90, "zuletzt getestet");
        addMinMaxWidthColumn(90, "zuletzt richtig");
        addMinWidthColumn(100, "letzte 10 Ergebnisse");
        addMinMaxWidthColumn(50, "Interna");
        if (options.isShowNumberOfListsInLister()) {
            addMinMaxWidthColumn(45, "Listen");
        }
    }

}
