package de.duehl.vocabulary.japanese.website.download;

import java.util.ArrayList;
import java.util.List;

import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.parser.NewestOwnListsVersionParser;

import static de.duehl.vocabulary.japanese.common.website.VocaluaryTrainerWebsiteConstants.NEWEST_OWN_LISTS_VERSION_ON_SERVER_URL;
import static de.duehl.vocabulary.japanese.common.website.download.WebsiteFileContentDownloader.NO_DOWNLOAD_SUCCESS;
import static de.duehl.vocabulary.japanese.common.website.download.WebsiteFileContentDownloader.downloadFileViaUrlFromServer;

/**
 * Diese Klasse lädt die Liste der Einträge in der Datei Neuste_Version_Listen.txt vom Server
 * herunter und parsed sie.
 *
 * @version 1.01     2024-10-12
 * @author Christian Dühl
 */

public class NewestOwnListVersionListDownloader {

    /**
     * Lädt die Liste der Einträge in der Datei Neuste_Version_Listen.txt vom Server herunter und
     * parsed sie. Gibt es dabei ein Problem, wird eine leere Liste zurückgegeben.
     */
    public static List<NewestOwnListVersionListEntry> download() {
        String content = downloadFileViaUrlFromServer(NEWEST_OWN_LISTS_VERSION_ON_SERVER_URL);
        if (content.equals(NO_DOWNLOAD_SUCCESS)) {
            return new ArrayList<>();
        }

        NewestOwnListsVersionParser parser = new NewestOwnListsVersionParser(content);
        parser.parse();
        if (parser.isSuccess()) {
            return parser.getNewestOwnListVersionListEntries();
        }
        return new ArrayList<>();
    }

}
