package de.duehl.vocabulary.japanese.website.update.ownlists.groupfile.data;

/**
 * Diese Klasse stellt den Inhalt einer Gruppendatei dar, wie sie den ZIP-Archiven der Gruppen
 * beigelegt werden.
 *
 * In dieser Datei halte ich fest, zu welcher Listendatei welcher langer Name (mit Leerzeichen
 * etc.) gehört, damit man die Listen im Vokabeltrainer dann unter ihren originalen Namen
 * importieren kann.
 *
 * Der Inhalt enthält Zeilen der folgenden Art, wobei als Trenner ein Tabulator benutzt wird:
 *     b1K011SchreibbarMitAIUEO.owl -> B1 K01 1 Schreibbar mit a i u e o
 *
 * @version 1.01     2024-10-14
 * @author Christian Dühl
 */

public class GroupFileEntry {

    /** Der Dateiname ohne Pfad (z.b. "b1K054BBettUndBad.owl"). */
    private final String listBareFilename;

    /** Der Name der Liste (z.B. "B1 K05 4 B) Bett und Bad"). */
    private final String listName;

    /**
     * Konstruktor.
     *
     * @param listBareFilename
     *            Der Dateiname ohne Pfad (z.b. "b1K054BBettUndBad.owl").
     * @param listName
     *            Der Name der Liste (z.B. "B1 K05 4 B) Bett und Bad").
     */
    public GroupFileEntry(String listBareFilename, String listName) {
        this.listBareFilename = listBareFilename;
        this.listName = listName;
    }

    /** Getter für den Dateinamen ohne Pfad (z.b. "b1K054BBettUndBad.owl"). */
    public String getListBareFilename() {
        return listBareFilename;
    }

    /** Getter für den Namen der Liste (z.B. "B1 K05 4 B) Bett und Bad"). */
    public String getListName() {
        return listName;
    }

    @Override
    public String toString() {
        return "GroupFileEntry [listBareFilename=" + listBareFilename + ", listName=" + listName
                + "]";
    }

}
