/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.date.parse;

import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.text.Text;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class DateParseMethod {
    private static final Map<String, Integer> MONTH_NAME_TO_NUMBER_MAP = DateParseMethod.createMonthNameToNumberMap();
    private final String dateToParse;
    private final Pattern pattern;
    protected Matcher matcher;
    private ImmutualDate parsedDate;
    private boolean success;

    public DateParseMethod(String string, Pattern pattern) {
        this.dateToParse = string;
        this.pattern = pattern;
    }

    public void parse() {
        this.matcher = this.pattern.matcher(this.dateToParse);
        this.success = this.matcher.matches();
        if (this.success) {
            this.parsedDate = this.createDateFromMatcher();
        }
    }

    protected abstract ImmutualDate createDateFromMatcher();

    public boolean isSuccessfull() {
        return this.success;
    }

    public ImmutualDate getParsedDate() {
        return this.parsedDate;
    }

    private static Map<String, Integer> createMonthNameToNumberMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Januar", 1);
        hashMap.put("Jan", 1);
        hashMap.put("January", 1);
        hashMap.put("Februar", 2);
        hashMap.put("Feb", 2);
        hashMap.put("February", 2);
        hashMap.put("M\u00e4rz", 3);
        hashMap.put("Maerz", 3);
        hashMap.put("M\u00e4r", 3);
        hashMap.put("March", 3);
        hashMap.put("Mar", 3);
        hashMap.put("April", 4);
        hashMap.put("Apr", 4);
        hashMap.put("Mai", 5);
        hashMap.put("May", 5);
        hashMap.put("Juni", 6);
        hashMap.put("Jun", 6);
        hashMap.put("June", 6);
        hashMap.put("Juli", 7);
        hashMap.put("Jul", 7);
        hashMap.put("July", 7);
        hashMap.put("August", 8);
        hashMap.put("Aug", 8);
        hashMap.put("September", 9);
        hashMap.put("Sep", 9);
        hashMap.put("Sept", 9);
        hashMap.put("Oktober", 10);
        hashMap.put("Okt", 10);
        hashMap.put("October", 10);
        hashMap.put("Oct", 10);
        hashMap.put("November", 11);
        hashMap.put("Nov", 11);
        hashMap.put("Dezember", 12);
        hashMap.put("Dez", 12);
        hashMap.put("December", 12);
        hashMap.put("Dec", 12);
        return hashMap;
    }

    protected static int translateMonthFromStringToInt(String string) {
        String string2 = Text.removeTextAtEndIfEndsWith(string, ".");
        for (String string3 : MONTH_NAME_TO_NUMBER_MAP.keySet()) {
            if (!string2.equals(string3)) continue;
            return MONTH_NAME_TO_NUMBER_MAP.get(string3);
        }
        return 0;
    }
}

