/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

import de.duehl.basics.io.FileHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatchFileWithOwnJarActualiser {
    private final String directory;
    private final String version;
    private final Pattern jarPattern;
    private final String newJarBareFilename;
    private List<String> batchFilenames;
    private List<String> actualisedFilenames;

    public BatchFileWithOwnJarActualiser(String string, String string2, String string3) {
        this.directory = string;
        this.version = string3;
        String string4 = "^.*(" + Pattern.quote(string2) + "_[-_.0-9a-zA-Z]+\\.jar)\\b.*";
        this.jarPattern = Pattern.compile(string4);
        this.newJarBareFilename = string2 + "_" + string3 + ".jar";
    }

    public void actualize() {
        if (!this.version.isEmpty()) {
            this.findAllBatchfiles();
            this.findFilesToActualise();
            this.changeFilesToChange();
        }
    }

    private void findAllBatchfiles() {
        this.batchFilenames = FileHelper.findFilesInMainDirectoryNio2WithExtensions(this.directory, ".bat", ".cmd");
    }

    private void findFilesToActualise() {
        this.actualisedFilenames = new ArrayList<String>();
        for (String string : this.batchFilenames) {
            if (!this.isFileToActualise(string)) continue;
            this.actualisedFilenames.add(string);
        }
    }

    private boolean isFileToActualise(String string) {
        List<String> list = FileHelper.readFileToList(string);
        for (String string2 : list) {
            Matcher matcher = this.jarPattern.matcher(string2);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private void changeFilesToChange() {
        for (String string : this.actualisedFilenames) {
            this.changeFile(string);
        }
    }

    private void changeFile(String string) {
        List<String> list = FileHelper.readFileToList(string);
        List<String> list2 = this.changeLines(list);
        FileHelper.writeLinesToFile(list2, string);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> changeLines(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            void object;
            Matcher matcher = this.jarPattern.matcher(string);
            int n = -1;
            while (matcher.find()) {
                int n2 = matcher.start(1);
                int n3 = matcher.end(1);
                if (n2 <= n) continue;
                n = n2;
                String string2 = object.substring(0, n2);
                String string3 = object.substring(n3);
                String string4 = string2 + this.newJarBareFilename + string3;
                matcher = this.jarPattern.matcher(string4);
            }
            arrayList.add((String)object);
        }
        return arrayList;
    }

    public List<String> getActualisedFilenames() {
        return this.actualisedFilenames;
    }
}

