/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FineFileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.Objects;

public class FileFromJarReader
extends FineFileReader {
    public FileFromJarReader(Class<?> clazz, String string, Charset charset) {
        super(string, charset, FileFromJarReader.openReader(clazz, string, charset));
    }

    private static LineNumberReader openReader(Class<?> clazz, String string, Charset charset) {
        try {
            return FileFromJarReader.tryToOpenReader(clazz, string, charset);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static LineNumberReader tryToOpenReader(Class<?> clazz, String string, Charset charset) throws UnsupportedEncodingException {
        InputStream inputStream = Objects.requireNonNull(clazz.getResourceAsStream(string), "Die Datei '" + string + "' gibt es nicht!");
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset.getCharsetAsString());
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        return lineNumberReader;
    }
}

