/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.dictionary.join;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;

public class DictionaryJoiner {
    private final Dictionary dictionary1;
    private final Dictionary dictionary2;
    private Dictionary joinedDictionary;

    public DictionaryJoiner(Dictionary dictionary, Dictionary dictionary2) {
        this.dictionary1 = dictionary;
        this.dictionary2 = dictionary2;
    }

    public DictionaryJoiner(String string, Charset charset, String string2, Charset charset2) {
        this.dictionary1 = FileHelper.readDictionaryFromNormalTextFile(string, charset);
        this.dictionary2 = FileHelper.readDictionaryFromNormalTextFile(string2, charset2);
    }

    public void join() {
        this.joinedDictionary = new Dictionary();
        this.addDictionary(this.dictionary1);
        this.addDictionary(this.dictionary2);
    }

    private void addDictionary(Dictionary dictionary) {
        for (DictionaryEntry dictionaryEntry : dictionary) {
            this.addList(dictionaryEntry);
        }
    }

    private void addList(DictionaryEntry dictionaryEntry) {
        String string = dictionaryEntry.getMainWord();
        if (this.joinedDictionary.containsEntryWithMainWord(string)) {
            DictionaryEntry dictionaryEntry2 = this.joinedDictionary.getEntryWithMainWord(string);
            this.joinEntries(dictionaryEntry2, dictionaryEntry);
        } else {
            this.addNewEntry(dictionaryEntry);
        }
    }

    private void addNewEntry(DictionaryEntry dictionaryEntry) {
        DictionaryEntry dictionaryEntry2 = new DictionaryEntry(dictionaryEntry);
        this.joinedDictionary.addDictionaryEntry(dictionaryEntry2);
    }

    private void joinEntries(DictionaryEntry dictionaryEntry, DictionaryEntry dictionaryEntry2) {
        for (String string : dictionaryEntry2.getAlternatives()) {
            if (dictionaryEntry.contains(string)) continue;
            dictionaryEntry.addAlternative(string);
        }
    }

    public Dictionary getJoinedDictionary() {
        return this.joinedDictionary;
    }
}

