/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.split;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.io.Writer;
import de.duehl.basics.io.textfile.FullNormalTextFileReader;
import de.duehl.basics.text.NumberString;
import java.util.ArrayList;
import java.util.List;

public class TextFileSplitter {
    private final String filename;
    private final String splittedDirectory;
    private final Charset charset;
    private final int size;
    private final boolean hasTitles;
    private int opendFileNumber;
    private int numberOfReadInputLines;
    private Writer writer;
    private int numberOfCreatedSplitFiles;
    private List<String> filenamesOfCreatedSplitFiles;
    private boolean verbose;

    public TextFileSplitter(String string, Charset charset, int n, boolean bl) {
        this(string, FileHelper.getDirName(string), charset, n, bl);
    }

    public TextFileSplitter(String string, String string2, Charset charset, int n, boolean bl) {
        this.filename = string;
        this.splittedDirectory = string2;
        this.charset = charset;
        this.size = n;
        this.hasTitles = bl;
        this.verbose = true;
    }

    public void beQuiet() {
        this.verbose = false;
    }

    public void work() {
        this.opendFileNumber = 0;
        this.numberOfReadInputLines = 0;
        this.numberOfCreatedSplitFiles = 0;
        this.filenamesOfCreatedSplitFiles = new ArrayList<String>();
        this.workOnInputFile();
        this.closeActualOutputFile();
        this.say("Fertig.");
    }

    private void workOnInputFile() {
        this.say("Lese " + this.filename);
        FullNormalTextFileReader fullNormalTextFileReader = new FullNormalTextFileReader(this.filename, this.charset);
        fullNormalTextFileReader.setLineDescription("Datens\u00e4tze zum Aufteilen");
        fullNormalTextFileReader.setProgressTextStart("Einlesen");
        if (this.hasTitles) {
            fullNormalTextFileReader.skipFirstLine();
        }
        fullNormalTextFileReader.skipBlankLines();
        fullNormalTextFileReader.beQuiet();
        fullNormalTextFileReader.setNumberOfLinesReadToPrintProgress(1000);
        fullNormalTextFileReader.read(string -> this.analyseLine(string, fullNormalTextFileReader.getSkippedFirstLine()));
    }

    private void analyseLine(String string, String string2) {
        if (0 == this.opendFileNumber) {
            this.openNextOutputFile(string2);
        } else if (this.numberOfReadInputLines % this.size == 0) {
            this.closeActualOutputFile();
            this.openNextOutputFile(string2);
        }
        ++this.numberOfReadInputLines;
        this.writer.writeln(string);
    }

    private void openNextOutputFile(String string) {
        ++this.opendFileNumber;
        String string2 = this.generateOutputFilename();
        this.say("\u00d6ffne " + string2 + " zum Schreiben.");
        this.writer = new FineFileWriter(string2, this.charset);
        if (this.hasTitles && !string.isEmpty()) {
            this.writer.writeln(string);
        }
        ++this.numberOfCreatedSplitFiles;
        this.filenamesOfCreatedSplitFiles.add(string2);
    }

    private String generateOutputFilename() {
        String string = FileHelper.getBareName(this.filename);
        String string2 = FileHelper.insertBeforeExtension(string, "_" + NumberString.addLeadingZeroes(this.opendFileNumber, 4));
        String string3 = FileHelper.concatPathes(this.splittedDirectory, string2);
        if (this.filename.equals(string3)) {
            throw new RuntimeException("Ausgabename = Eingabename: " + this.filename);
        }
        return string3;
    }

    private void closeActualOutputFile() {
        this.writer.close();
    }

    private void say(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    public int getNumberOfCreatedSplitFiles() {
        return this.numberOfCreatedSplitFiles;
    }

    public List<String> getFilenamesOfCreatedSplitFiles() {
        return this.filenamesOfCreatedSplitFiles;
    }
}

