/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system.starter;

import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.io.FineFileWriter;
import de.duehl.basics.logging.Logger;
import de.duehl.basics.logging.NoLogger;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.system.starter.Starter;
import java.io.IOException;

public class SasStarter
extends Starter {
    private String sasBinary;

    public SasStarter(String string, ErrorHandler errorHandler) {
        this(string, new NoLogger(), errorHandler);
    }

    public SasStarter(String string, Logger logger, ErrorHandler errorHandler) {
        super(logger, errorHandler);
        this.sasBinary = string;
    }

    public String runInteractive(SasType sasType, String string) {
        String[] stringArray;
        Object object;
        this.log("Start, type = " + sasType + ", program = " + string);
        if (sasType != SasType.NORMAL) {
            object = new String[]{this.sasBinary};
            stringArray = object;
        } else {
            object = new String[]{this.sasBinary, "-CONFIG", this.config(sasType)};
            stringArray = object;
        }
        object = new ProcessBuilder(stringArray);
        Process process = null;
        try {
            process = ((ProcessBuilder)object).start();
        }
        catch (IOException iOException) {
            this.error.error("Es trat ein Fehler bei der Ausf\u00fchrung des SAS-Prozesses auf.");
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.log("Ende, type = " + sasType + ", program = " + string);
        return this.paramsToString(stringArray);
    }

    public String runAndWait(SasType sasType, String string, String string2, String string3) {
        String[] stringArray;
        Object object;
        this.log("Start, type = " + sasType + ", program = " + string + ", log = " + string2 + ", errorLog = " + string3);
        if (sasType == SasType.NORMAL) {
            object = new String[]{this.sasBinary, "-SYSIN", string, "-LOG", string2};
            stringArray = object;
        } else {
            object = new String[]{this.sasBinary, "-CONFIG", this.config(sasType), "-SYSIN", string, "-LOG", string2};
            stringArray = object;
        }
        object = new ProcessBuilder(stringArray);
        Process process = null;
        try {
            process = ((ProcessBuilder)object).start();
        }
        catch (IOException iOException) {
            this.error.error("Es trat ein Fehler bei der Ausf\u00fchrung des SAS-Prozesses auf.");
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.grepErrors(string2, string3);
        this.log("Ende, type = " + sasType + ", program = " + string + ", log = " + string2 + ", errorLog = " + string3);
        return this.paramsToString(stringArray);
    }

    private String config(SasType sasType) {
        String string = null;
        switch (sasType) {
            case BANZ_MPO_OHNE: {
                string = "//cluster1/Projekte1/HRTag/HR_Strukt_HuP/sasv9ohne.cfg";
                break;
            }
            case BANZ_MPO: {
                string = "//cluster1/Projekte1/HRTag/HR_Strukt_HuP/sasv9.cfg";
                break;
            }
            case AS400: {
                string = "C:/SAS/SAS 9.1/nls/en/SASV9P400.CFG";
                break;
            }
        }
        return string;
    }

    private void grepErrors(String string, String string2) {
        FineFileReader fineFileReader = new FineFileReader(string);
        FineFileWriter fineFileWriter = new FineFileWriter(string2);
        String string3 = fineFileReader.readNextLine();
        while (string3 != null) {
            String string4 = string3.replace("_ERROR_", "_XXX_").toLowerCase();
            if (string4.contains("error")) {
                fineFileWriter.write(fineFileReader.getLineNumber() + ": ");
                fineFileWriter.writeln(string3);
            }
            string3 = fineFileReader.readNextLine();
        }
        fineFileWriter.close();
        fineFileReader.close();
    }

    public static enum SasType {
        BANZ_MPO_OHNE,
        BANZ_MPO,
        AS400,
        NORMAL;

    }
}

