/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.system.windows;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class WindowsShortcutCreator {
    private final File sourceFile;
    private String linkFilename;
    private String iconFilename;
    private String workingDirectory;

    public WindowsShortcutCreator(String string) {
        this.sourceFile = new File(string);
        this.iconFilename = "";
        this.workingDirectory = "";
    }

    public void createDesktopShortcut(String string) {
        this.createShortcutAtGivenPath(WindowsShortcutCreator.createDesktopLinkPath(string));
    }

    private static String createDesktopLinkPath(String string) {
        return System.getProperty("user.home") + "\\Desktop\\" + string;
    }

    public void createShortcutAtGivenPath(String string) {
        this.linkFilename = string;
    }

    public void setIcon(String string) {
        this.iconFilename = string;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void create() {
        String string;
        Object object;
        this.checkSourceFileExists();
        this.checkLinkFilenameEndsWithLnk();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Set wsObj = WScript.CreateObject(\"WScript.shell\")\n");
        stringBuilder.append("scPath = \"").append(this.linkFilename).append("\"\n");
        stringBuilder.append("Set scObj = wsObj.CreateShortcut(scPath)\n");
        String string2 = this.sourceFile.getAbsolutePath();
        stringBuilder.append("\tscObj.TargetPath = \"").append(string2).append("\"\n");
        if (!this.iconFilename.isBlank()) {
            object = new File(this.iconFilename);
            if (!((File)object).exists()) {
                throw new RuntimeException("Der Pfad " + ((File)object).getAbsolutePath() + " existiert nicht.");
            }
            string = ((File)object).getAbsolutePath();
            stringBuilder.append("\tscObj.IconLocation = \"").append(string).append("\"\n");
        }
        if (!this.workingDirectory.isBlank()) {
            object = new File(this.workingDirectory);
            if (!((File)object).isDirectory()) {
                throw new RuntimeException("Das Verzeichnis " + ((File)object).getAbsolutePath() + " existiert nicht.");
            }
            string = ((File)object).getAbsolutePath();
            stringBuilder.append("\tscObj.WorkingDirectory = \"").append(string).append("\"\n");
        }
        stringBuilder.append("scObj.Save\n");
        object = stringBuilder.toString();
        this.createRunAndDeleteVbs((String)object);
    }

    private void checkSourceFileExists() {
        if (!this.sourceFile.exists()) {
            throw new RuntimeException("Der Pfad " + this.sourceFile.getAbsolutePath() + " existiert nicht.");
        }
    }

    private void checkLinkFilenameEndsWithLnk() {
        if (!this.linkFilename.endsWith(".lnk")) {
            throw new RuntimeException("Der Dateiname der Verkn\u00fcppfung muss auf '.lnk' enden.");
        }
    }

    private void createRunAndDeleteVbs(String string) {
        try {
            this.tryToCreateRunAndDeleteVbs(string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Beim Versuch VBS-Code in eine tempor\u00e4re Datei zu schreiben und auszuf\u00fchren, trat ein Problem auf.\n\tvbsCode: \n" + string + "\n\tMeldung: " + exception.getMessage() + "\nM\u00f6glicherweise ist die tempor\u00e4r angelegte Datei mit dem VBS-Code noch vorhanden.\n");
        }
    }

    private void tryToCreateRunAndDeleteVbs(String string) throws IOException, InterruptedException {
        File file = File.createTempFile("verknuepfung_anlegen_", ".vbs");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
        Process process = Runtime.getRuntime().exec("wscript \"" + file.getAbsolutePath() + "\"");
        process.waitFor();
        boolean bl = file.delete();
        if (!bl) {
            System.err.println("Warnung: Die tempor\u00e4r angelegte Datei '" + file.getAbsolutePath() + "' konnte nicht gel\u00f6scht werden.");
        }
    }
}

