/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.textfile.dictionary.Dictionary;
import de.duehl.basics.io.textfile.dictionary.DictionaryEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpellingErrorCorrector {
    private final List<String> mispelledPhrases = new ArrayList<String>();
    private final Map<String, String> mispelledToCorrectWords = new HashMap<String, String>();

    public SpellingErrorCorrector(Dictionary dictionary) {
        this.initListAndMapWithDictionary(dictionary);
        this.sortMispelledPhrasesByLengthDescanding();
    }

    private void initListAndMapWithDictionary(Dictionary dictionary) {
        for (DictionaryEntry dictionaryEntry : dictionary) {
            this.initListAndMapWithDictionaryList(dictionaryEntry);
        }
    }

    private void initListAndMapWithDictionaryList(DictionaryEntry dictionaryEntry) {
        String string = dictionaryEntry.getMainWord();
        List<String> list = dictionaryEntry.getAlternatives();
        if (list.isEmpty()) {
            throw new RuntimeException("Eine Liste im Dictionary enth\u00e4lt nur ein richtig geschriebenes Wort, aber keine falsch geschriebenen: '" + string + "'.");
        }
        for (String string2 : list) {
            if (this.mispelledPhrases.contains(string2)) {
                throw new RuntimeException("Falschgeschriebener Begriff ist doppelt vorhanden: '" + string2 + "'.");
            }
            this.mispelledPhrases.add(string2);
            this.mispelledToCorrectWords.put(string2, string);
        }
    }

    private void sortMispelledPhrasesByLengthDescanding() {
        CollectionsHelper.sortStringListByLengthDescanding(this.mispelledPhrases);
    }

    public String correct(String string) {
        String string2 = string;
        for (String string3 : this.mispelledPhrases) {
            String string4 = this.mispelledToCorrectWords.get(string3);
            string2 = string2.replace(string3, string4);
        }
        return string2;
    }

    public void correct(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2 = list.get(i);
            if (string2.equals(string = this.correct(string2))) continue;
            list.set(i, string);
        }
    }

    public List<String> getMispelledPhrases() {
        return this.mispelledPhrases;
    }
}

