/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public class TextBreaker {
    private final int lineLength;
    private final int numberOfFrontSpaces;
    private boolean keepSpacesAtBreaks;
    private boolean firstOutputLine;

    public TextBreaker(int n) {
        this(n, 0);
    }

    public TextBreaker(int n, int n2) {
        if (n2 >= n) {
            throw new IllegalArgumentException("Zu wenig Platz f\u00fcr den umzubrechenden Text!");
        }
        this.lineLength = n - n2;
        this.numberOfFrontSpaces = n2;
        this.keepSpacesAtBreaks = false;
    }

    public void keepSpacesAtBreaks() {
        this.keepSpacesAtBreaks = true;
    }

    public String addLineBreaks(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.firstOutputLine = true;
        for (String string2 : Text.splitByLineBreaks(string)) {
            arrayList.addAll(this.breakAtSpaces(string2));
            this.firstOutputLine = false;
        }
        return this.generateOutputString(arrayList);
    }

    private String generateOutputString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(Text.LINE_BREAK);
                stringBuilder.append(Text.multipleString(' ', this.numberOfFrontSpaces));
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private List<String> breakAtSpaces(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.textIsSmallEnough(string) || this.textHasNoSpaces(string)) {
            arrayList.add(string);
            this.firstOutputLine = false;
        } else {
            arrayList.addAll(this.breakAtBestSpace(string));
        }
        return arrayList;
    }

    private List<String> breakAtBestSpace(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.indexOf(" ");
        if (this.textIsSmallEnoughAtSpaceIndex(n2)) {
            int n3 = n2;
            int n4 = string.indexOf(" ", n3 + 1);
            while (n4 > -1 && this.textIsSmallEnoughAtSpaceIndex(n4)) {
                n3 = n4;
                n4 = string.indexOf(" ", n3 + 1);
            }
            n = n3;
        } else {
            n = n2;
        }
        String string2 = this.keepSpacesAtBreaks ? string.substring(0, n + 1) : string.substring(0, n);
        String string3 = string.substring(n + 1);
        arrayList.add(string2);
        this.firstOutputLine = false;
        arrayList.addAll(this.breakAtSpaces(string3));
        return arrayList;
    }

    private boolean textIsSmallEnough(String string) {
        return string.length() <= this.determineLineLengthToCheck();
    }

    private boolean textIsSmallEnoughAtSpaceIndex(int n) {
        if (this.keepSpacesAtBreaks) {
            return n + 1 <= this.determineLineLengthToCheck();
        }
        return n <= this.determineLineLengthToCheck();
    }

    private int determineLineLengthToCheck() {
        if (this.firstOutputLine) {
            return this.lineLength + this.numberOfFrontSpaces;
        }
        return this.lineLength;
    }

    private boolean textHasNoSpaces(String string) {
        return !string.contains(" ");
    }
}

