/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.data;

import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class FoundSearch
implements Comparable<FoundSearch> {
    public static final FoundSearch NOT_FOUND = new FoundSearch(-1, "SUCHBEGRIFF LIEGT NICHT VOR!");
    private final int index;
    private final String search;

    public FoundSearch(int n, String string) {
        this.index = n;
        this.search = string;
    }

    public int getIndex() {
        return this.index;
    }

    public String getSearch() {
        return this.search;
    }

    public int getEnd() {
        return this.index + this.search.length();
    }

    public boolean wasSuccessfull() {
        return !this.equals(NOT_FOUND);
    }

    public boolean isBehind(FoundSearch foundSearch) {
        return this.index > foundSearch.index;
    }

    public boolean isIn(FoundSearch foundSearch) {
        return foundSearch.index <= this.index && foundSearch.getEnd() >= this.getEnd();
    }

    public String toString() {
        return "FoundSearch [index=" + this.index + ", search=" + this.search + "]";
    }

    @Override
    public int compareTo(FoundSearch foundSearch) {
        return this.index - foundSearch.index;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.search);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FoundSearch foundSearch = (FoundSearch)object;
        return this.index == foundSearch.index && Objects.equals(this.search, foundSearch.search);
    }

    public static void sortFoundSearchListByIndex(List<FoundSearch> list) {
        Collections.sort(list, new Comparator<FoundSearch>(){

            @Override
            public int compare(FoundSearch foundSearch, FoundSearch foundSearch2) {
                int n = foundSearch.getIndex();
                int n2 = foundSearch2.getIndex();
                return n - n2;
            }
        });
    }

    public static void sortFoundSearchListReverseByEndAndIndex(List<FoundSearch> list) {
        Collections.sort(list, new Comparator<FoundSearch>(){

            @Override
            public int compare(FoundSearch foundSearch, FoundSearch foundSearch2) {
                int n;
                int n2 = foundSearch.getEnd();
                if (n2 != (n = foundSearch2.getEnd())) {
                    return n - n2;
                }
                int n3 = foundSearch.getIndex();
                int n4 = foundSearch2.getIndex();
                return n3 - n4;
            }
        });
    }

    public static List<FoundSearch> findAll(String string, List<String> list) {
        ArrayList<FoundSearch> arrayList = new ArrayList<FoundSearch>();
        for (String string2 : list) {
            List<Integer> list2 = Text.findAllPositions(string2, string);
            for (int n : list2) {
                FoundSearch foundSearch = new FoundSearch(n, string2);
                arrayList.add(foundSearch);
            }
        }
        return arrayList;
    }
}

