/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.xml.own;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.FineFileReader;
import de.duehl.basics.text.xml.own.SingleElementFromLineCreator;
import java.util.ArrayList;
import java.util.List;

public class OwnXmlIO {
    private final String xmlCollectionTag;
    private final String xmlDataTag;

    public OwnXmlIO(String string, String string2) {
        this.xmlCollectionTag = string;
        this.xmlDataTag = string2;
    }

    public void loadFromXmlLines(List<String> list, SingleElementFromLineCreator singleElementFromLineCreator) {
        boolean bl = false;
        for (String string : list) {
            if ((string = string.trim()).equals("<" + this.xmlCollectionTag + ">")) {
                bl = true;
                continue;
            }
            if (string.equals("</" + this.xmlCollectionTag + ">")) {
                bl = false;
                continue;
            }
            if (!bl) continue;
            if (string.startsWith("<" + this.xmlDataTag + ">") && string.endsWith("</" + this.xmlDataTag + ">")) {
                singleElementFromLineCreator.createAndStoreElementFromLine(string);
                continue;
            }
            throw new IllegalArgumentException("Kein <" + this.xmlDataTag + ">...</" + this.xmlDataTag + "> in der Zeile gefunden.\nZeile ist (getrimmt):\n\t" + string + "\nGesamte Xml-Zeilen sind:\n" + CollectionsHelper.listListNice(list));
        }
    }

    public void load(String string, SingleElementFromLineCreator singleElementFromLineCreator) {
        List<String> list = FileHelper.readFileToList(string);
        this.loadFromXmlLines(list, singleElementFromLineCreator);
    }

    public void loadFromVeryLongFile(String string, SingleElementFromLineCreator singleElementFromLineCreator) {
        String string2;
        FineFileReader fineFileReader = new FineFileReader(string);
        boolean bl = false;
        while ((string2 = fineFileReader.readNextLine()) != null) {
            if ((string2 = string2.trim()).equals("<" + this.xmlCollectionTag + ">")) {
                bl = true;
                continue;
            }
            if (string2.equals("</" + this.xmlCollectionTag + ">")) {
                bl = false;
                continue;
            }
            if (!bl) continue;
            if (string2.startsWith("<" + this.xmlDataTag + ">") && string2.endsWith("</" + this.xmlDataTag + ">")) {
                singleElementFromLineCreator.createAndStoreElementFromLine(string2);
                continue;
            }
            throw new IllegalArgumentException("Kein <" + this.xmlDataTag + ">...</" + this.xmlDataTag + "> in Zeile " + fineFileReader.getLineNumber() + " gefunden. Zeile ist (getrimmt):\n\t" + string2 + "\nDatei ist: " + string + "\n");
        }
        fineFileReader.close();
    }

    public void save(String string, List<String> list) {
        FileHelper.writeLinesToFile(this.createSaveLines(list), string);
    }

    public List<String> createSaveLines(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<" + this.xmlCollectionTag + ">");
        for (String string : list) {
            arrayList.add("    " + string);
        }
        arrayList.add("</" + this.xmlCollectionTag + ">");
        return arrayList;
    }
}

