/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text.xml.own;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.Text;
import de.duehl.basics.text.xml.XmlAnalyser;
import de.duehl.basics.text.xml.own.OwnXmlIO;
import de.duehl.basics.text.xml.own.SingleElementFromLineCreator;
import de.duehl.basics.text.xml.own.XmlStorable;
import java.util.ArrayList;
import java.util.List;

public class XmlStorableIO {
    private final String xmlCollectionTag;
    private final List<XmlStorable> storables;

    public XmlStorableIO(String string) {
        this.xmlCollectionTag = string;
        this.storables = new ArrayList<XmlStorable>();
    }

    public void addStorable(XmlStorable xmlStorable) {
        this.storables.add(xmlStorable);
    }

    public void save(String string) {
        FileHelper.writeLinesToFile(this.createSaveLines(), string);
    }

    public List<String> createSaveLines() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<" + this.xmlCollectionTag + ">");
        for (XmlStorable xmlStorable : this.storables) {
            String string = Text.indent(xmlStorable.toXml());
            List<String> list = Text.splitByLineBreaks(string);
            arrayList.addAll(list);
        }
        arrayList.add("</" + this.xmlCollectionTag + ">");
        return arrayList;
    }

    public void loadFromXmlLines(List<String> list, String string, SingleElementFromLineCreator singleElementFromLineCreator) {
        List<String> list2 = XmlStorableIO.createListOfConnectedLines(list, this.xmlCollectionTag, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<" + this.xmlCollectionTag + ">");
        arrayList.addAll(list2);
        arrayList.add("</" + this.xmlCollectionTag + ">");
        OwnXmlIO ownXmlIO = new OwnXmlIO(this.xmlCollectionTag, string);
        ownXmlIO.loadFromXmlLines(arrayList, singleElementFromLineCreator);
    }

    public static List<String> createListOfConnectedLines(List<String> list, String string, String string2) {
        List<String> list2 = XmlAnalyser.getLinesInTag(list, string);
        List<List<String>> list3 = XmlAnalyser.getMultipleLinesInTagAllowEmptyList(list2, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (List<String> list4 : list3) {
            arrayList.add(Text.joinWithLineBreak(list4));
        }
        return arrayList;
    }

    public void load(String string, String string2, SingleElementFromLineCreator singleElementFromLineCreator) {
        List<String> list = FileHelper.readFileToList(string);
        this.loadFromXmlLines(list, string2, singleElementFromLineCreator);
    }
}

