/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.data;

import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import java.util.List;

public class MinuteHour {
    private final String minute;
    private final String hour;

    public MinuteHour(String string) {
        if (string.length() != 5) {
            throw new IllegalArgumentException("Der Text muss f\u00fcnf Zeichen lang sein, denn er stellt eine Uhrzeit dar im Format 'HH:MM'! \u00dcbergebener Text: '" + string + "'.");
        }
        List<String> list = Text.splitByColon(string);
        if (list.size() != 2) {
            throw new IllegalArgumentException("Der Text muss sich am Semikolon in zwei Teile teilen lassen, denn er stellt eine Uhrzeit dar im Format 'HH:MM'! \u00dcbergebener Text: '" + string + "'.");
        }
        this.hour = list.get(0);
        this.minute = list.get(1);
        if (this.hour.length() != 2) {
            throw new IllegalArgumentException("Die Stunden m\u00fcssen zwei Stellen lang sein, denn der Text stellt eine Uhrzeit dar im Format 'HH:MM'! \u00dcbergebener Text: '" + string + "'.");
        }
        if (this.minute.length() != 2) {
            throw new IllegalArgumentException("Die Minuten m\u00fcssen zwei Stellen lang sein, denn der Text stellt eine Uhrzeit dar im Format 'HH:MM'! \u00dcbergebener Text: '" + string + "'.");
        }
    }

    public String getMinute() {
        return this.minute;
    }

    public String getHour() {
        return this.hour;
    }

    public int getHoursAsInteger() {
        return NumberString.twoDigitStringToInteger(this.hour);
    }

    public int getMinuteAsInteger() {
        return NumberString.twoDigitStringToInteger(this.minute);
    }

    public String toString() {
        return this.hour + ":" + this.minute;
    }
}

