/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.debug;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.ImmutualTime;
import de.duehl.swing.debug.GuiDebugSaver;
import de.duehl.swing.debug.data.DebugMessage;
import de.duehl.swing.debug.dialog.GuiDebugDialog;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GuiDebug {
    public static final String ALL_CATEGORY = "###_ALL_DO_NOT_USE_ELSEWHERE###";
    private final List<String> categories = new ArrayList<String>();
    private final Map<String, List<DebugMessage>> messagesByCategory = new HashMap<String, List<DebugMessage>>();

    public void registerCategories(List<String> list) {
        if (!this.categories.isEmpty()) {
            throw new RuntimeException("Die Kategorien k\u00f6nnen nur genau einmal registriert werden.");
        }
        if (list.contains(ALL_CATEGORY)) {
            throw new RuntimeException("Die Kategorie '###_ALL_DO_NOT_USE_ELSEWHERE###' darf nicht verwendet werden.");
        }
        if (!CollectionsHelper.isDisjunct(list)) {
            throw new RuntimeException("Die Kategorien m\u00fcssen disjunkt sein.");
        }
        this.categories.add(ALL_CATEGORY);
        this.categories.addAll(list);
        this.initialiseMessagesByCategory();
    }

    private void initialiseMessagesByCategory() {
        this.messagesByCategory.clear();
        for (String string : this.categories) {
            this.messagesByCategory.put(string, new ArrayList());
        }
    }

    public void debug(String string, String string2) {
        Object object;
        int n;
        if (!this.categories.contains(string)) {
            throw new RuntimeException("Meldung zu einer nicht registrierten Kategorie: " + string);
        }
        DateAndTime dateAndTime = new DateAndTime();
        ImmutualDate immutualDate = dateAndTime.getDate();
        ImmutualTime immutualTime = dateAndTime.getTime();
        String string3 = "dummyClass";
        String string4 = "dummyMethod";
        String string5 = "x";
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (stackTraceElementArray.length > (n = 4)) {
            object = stackTraceElementArray[n];
            string3 = ((StackTraceElement)object).getClassName();
            string4 = ((StackTraceElement)object).getMethodName();
            string5 = Integer.toString(((StackTraceElement)object).getLineNumber());
        }
        object = new DebugMessage(immutualDate, immutualTime, string, string3, string4, string5, string2);
        List<DebugMessage> list = this.messagesByCategory.get(string);
        list.add((DebugMessage)object);
        List<DebugMessage> list2 = this.messagesByCategory.get(ALL_CATEGORY);
        list2.add((DebugMessage)object);
    }

    public void createAndShowDialog(Point point, Image image) {
        GuiDebugDialog guiDebugDialog = new GuiDebugDialog(this.categories, this.messagesByCategory, point, image);
        guiDebugDialog.setVisible(true);
    }

    public void saveAll(String string) {
        GuiDebugSaver guiDebugSaver = new GuiDebugSaver(this.categories, this.messagesByCategory);
        guiDebugSaver.saveAll(string);
    }

    public void saveByCategories(String string) {
        GuiDebugSaver guiDebugSaver = new GuiDebugSaver(this.categories, this.messagesByCategory);
        guiDebugSaver.saveByCategories(string);
    }
}

