/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.GuiTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitledLabel {
    private final JLabel titleLabel;
    private final JLabel valueLabel;
    private final Component panel;
    private final Dimension initialTitleDimension;
    private final Color initialValueColor;
    private final boolean setTitelDimension;
    private final boolean setValueColor;

    public TitledLabel() {
        this("", "");
    }

    public TitledLabel(String string, String string2) {
        this.initialTitleDimension = new Dimension(0, 0);
        this.initialValueColor = Color.BLACK;
        this.setTitelDimension = false;
        this.setValueColor = false;
        this.titleLabel = new JLabel(string);
        this.valueLabel = new JLabel(string2);
        this.panel = this.createTitledValue();
    }

    public TitledLabel(Dimension dimension, Color color) {
        this(dimension, color, "", "");
    }

    public TitledLabel(Dimension dimension, Color color, String string, String string2) {
        this.initialTitleDimension = dimension;
        this.initialValueColor = color;
        this.setTitelDimension = true;
        this.setValueColor = true;
        this.titleLabel = new JLabel(string);
        this.valueLabel = new JLabel(string2);
        this.panel = this.createTitledValue();
    }

    private Component createTitledValue() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createTitleLabel(), "West");
        jPanel.add((Component)this.createValueLabel(), "Center");
        return jPanel;
    }

    private Component createTitleLabel() {
        if (this.setTitelDimension) {
            this.titleLabel.setPreferredSize(this.initialTitleDimension);
        }
        return this.titleLabel;
    }

    private JLabel createValueLabel() {
        if (this.setValueColor) {
            this.valueLabel.setForeground(this.initialValueColor);
        }
        return this.valueLabel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
        this.panel.repaint();
    }

    public void setValue(String string) {
        this.valueLabel.setText(string);
        this.panel.repaint();
    }

    public void useMonospacedFontForTheValue() {
        GuiTools.setMonospacedFont(this.valueLabel);
        this.panel.repaint();
    }

    public void setPreferredSize(Dimension dimension) {
        this.panel.setPreferredSize(dimension);
    }

    public void setPreferredTitleSize(Dimension dimension) {
        this.titleLabel.setPreferredSize(dimension);
    }

    public void setValueColor(Color color) {
        this.valueLabel.setForeground(color);
    }
}

