/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.selections;

import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.data.SearchWordSelectionInputs;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class SearchWordStringSelection
extends StringSelection {
    private final JCheckBox wholeWordCheckBox = new JCheckBox("ganzes Wort");
    private final JCheckBox caseSensitivCheckBox = new JCheckBox("Gro\u00df-/Kleinschreibung");

    public SearchWordStringSelection(String string) {
        super(string);
        this.mainPanel = this.createNewMainPanel();
    }

    private JPanel createNewMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)super.createPanel(), "Center");
        jPanel.add(this.createSearchOptionsPart(), "South");
        return jPanel;
    }

    private Component createSearchOptionsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.wholeWordCheckBox, "West");
        jPanel.add((Component)this.caseSensitivCheckBox, "East");
        return jPanel;
    }

    @Override
    public void makeHorizontal() {
        throw new RuntimeException("not implemented");
    }

    public boolean isWholeWordSearch() {
        return this.wholeWordCheckBox.isSelected();
    }

    public void setWholeWordSearch(boolean bl) {
        this.wholeWordCheckBox.setSelected(bl);
    }

    public boolean isCaseSensitiveSearch() {
        return this.caseSensitivCheckBox.isSelected();
    }

    public void setCaseSensitiveSearch(boolean bl) {
        this.caseSensitivCheckBox.setSelected(bl);
    }

    public void loadInputs(SearchWordSelectionInputs searchWordSelectionInputs) {
        this.setText(searchWordSelectionInputs.getText());
        this.setWholeWordSearch(searchWordSelectionInputs.isWholeWordSearch());
        this.setCaseSensitiveSearch(searchWordSelectionInputs.isCaseSensitiveSearch());
    }

    public void storeInputs(SearchWordSelectionInputs searchWordSelectionInputs) {
        searchWordSelectionInputs.setText(this.getTrimmedText());
        searchWordSelectionInputs.setWholeWordSearch(this.isWholeWordSearch());
        searchWordSelectionInputs.setCaseSensitiveSearch(this.isCaseSensitiveSearch());
    }

    public SearchWordSelectionInputs getInputs() {
        SearchWordSelectionInputs searchWordSelectionInputs = new SearchWordSelectionInputs();
        this.storeInputs(searchWordSelectionInputs);
        return searchWordSelectionInputs;
    }

    public void setCheckboxesFocusable(boolean bl) {
        this.wholeWordCheckBox.setFocusable(bl);
        this.caseSensitivCheckBox.setFocusable(bl);
    }
}

