/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.dialogs.lists.ui;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.DownButton;
import de.duehl.swing.ui.buttons.painted.EditButton;
import de.duehl.swing.ui.buttons.painted.UpButton;
import de.duehl.swing.ui.buttons.painted.XButton;
import de.duehl.swing.ui.colors.ColorTool;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableList;
import de.duehl.swing.ui.dialogs.lists.logic.LogicalEditableListElement;
import de.duehl.swing.ui.dialogs.lists.ui.UiElementListModifier;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class EditableListElement<LogicalElement extends LogicalEditableListElement> {
    public static final String TITLE_COLOR = "darkblue";
    private static final String DELETE_BUTTON_COLOR = "red";
    private static final String MOVE_BUTTON_COLOR = "darkgreen";
    private static final String DISABLED_COLOR = "darkgray";
    private final LogicalElement logicalElement;
    private final LogicalEditableList<LogicalElement> logicalList;
    private final UiElementListModifier<LogicalElement> uiListElementRemover;

    public EditableListElement(LogicalElement LogicalElement, LogicalEditableList<LogicalElement> logicalEditableList, UiElementListModifier<LogicalElement> uiElementListModifier) {
        this.logicalElement = LogicalElement;
        this.logicalList = logicalEditableList;
        this.uiListElementRemover = uiElementListModifier;
    }

    public final Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(2, 0, 1, 0));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createLeftElementLineButtonsPart(), "West");
        jPanel.add(this.createElementComponent(), "Center");
        jPanel.add(this.createRightElementLineButtonsPart(), "East");
        return jPanel;
    }

    private JPanel createLeftElementLineButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.createMoveUpButton());
        jPanel.add(this.createMoveDownButton());
        return jPanel;
    }

    private Component createMoveUpButton() {
        boolean bl = this.logicalList.canMoveUp(this.logicalElement);
        Color color = bl ? ColorTool.getColorByName(MOVE_BUTTON_COLOR) : ColorTool.getColorByName(DISABLED_COLOR);
        UpButton upButton = new UpButton(color);
        upButton.forceSquare();
        upButton.addActionListener(actionEvent -> this.moveUp());
        upButton.setEnabled(bl);
        return upButton;
    }

    private void moveUp() {
        this.logicalList.moveUp(this.logicalElement);
        this.updateElementsPanel();
    }

    private Component createMoveDownButton() {
        boolean bl = this.logicalList.canMoveDown(this.logicalElement);
        Color color = bl ? ColorTool.getColorByName(MOVE_BUTTON_COLOR) : ColorTool.getColorByName(DISABLED_COLOR);
        DownButton downButton = new DownButton(color);
        downButton.forceSquare();
        downButton.addActionListener(actionEvent -> this.moveDown());
        downButton.setEnabled(bl);
        return downButton;
    }

    private void moveDown() {
        this.logicalList.moveDown(this.logicalElement);
        this.updateElementsPanel();
    }

    protected abstract Component createElementComponent();

    private Component createRightElementLineButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.createDeleteButton());
        jPanel.add(this.createEditButton());
        return jPanel;
    }

    private Component createDeleteButton() {
        XButton xButton = new XButton(ColorTool.getColorByName(DELETE_BUTTON_COLOR));
        xButton.forceSquare();
        xButton.addActionListener(actionEvent -> this.deleteElement());
        return xButton;
    }

    private void deleteElement() {
        this.uiListElementRemover.removeElementFromList(this.getLogicalElement());
    }

    private Component createEditButton() {
        EditButton editButton = new EditButton();
        editButton.addActionListener(actionEvent -> this.editElement());
        return editButton;
    }

    public final void editElement() {
        this.editElement(this.uiListElementRemover.getComponent());
        if (this.logicalList.containedMoreThanOnce(this.getLogicalElement())) {
            this.uiListElementRemover.removeElementFromList(this.getLogicalElement());
            GuiTools.informUser(this.uiListElementRemover.getComponent(), "Dublette erzeugt!", "Das Element gab es in nun doppelt in der Liste, daher wurde es entfernt!");
        }
    }

    protected abstract void editElement(Component var1);

    public final LogicalElement getLogicalElement() {
        return this.logicalElement;
    }

    protected final void updateElementsPanel() {
        this.uiListElementRemover.updateElementsPanel();
    }

    public abstract JButton createSelectButton();
}

