/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;

public class TextLineNumber
extends JPanel
implements CaretListener,
DocumentListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final float LEFT = 0.0f;
    public static final float CENTER = 0.5f;
    public static final float RIGHT = 1.0f;
    private static final Border OUTER = new MatteBorder(0, 0, 0, 2, Color.GRAY);
    private static final int HEIGHT = 2146483647;
    private JTextComponent component;
    private boolean updateFont;
    private int borderGap;
    private Color currentLineForeground;
    private float digitAlignment;
    private int minimumDisplayDigits;
    private int lastDigits;
    private int lastHeight;
    private int lastLine;
    private HashMap<String, FontMetrics> fonts;

    public TextLineNumber(JTextComponent jTextComponent) {
        this(jTextComponent, 3);
    }

    public TextLineNumber(JTextComponent jTextComponent, int n) {
        this.component = jTextComponent;
        this.setFont(jTextComponent.getFont());
        this.setBorderGap(5);
        this.setCurrentLineForeground(Color.RED);
        this.setDigitAlignment(1.0f);
        this.setMinimumDisplayDigits(n);
        jTextComponent.getDocument().addDocumentListener(this);
        jTextComponent.addCaretListener(this);
        jTextComponent.addPropertyChangeListener("font", this);
    }

    public boolean getUpdateFont() {
        return this.updateFont;
    }

    public void setUpdateFont(boolean bl) {
        this.updateFont = bl;
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public void setBorderGap(int n) {
        this.borderGap = n;
        EmptyBorder emptyBorder = new EmptyBorder(0, n, 0, n);
        this.setBorder(new CompoundBorder(OUTER, emptyBorder));
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    public Color getCurrentLineForeground() {
        return this.currentLineForeground == null ? this.getForeground() : this.currentLineForeground;
    }

    public void setCurrentLineForeground(Color color) {
        this.currentLineForeground = color;
    }

    public float getDigitAlignment() {
        return this.digitAlignment;
    }

    public void setDigitAlignment(float f) {
        this.digitAlignment = f > 1.0f ? 1.0f : (f < 0.0f ? -1.0f : f);
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int n) {
        this.minimumDisplayDigits = n;
        this.setPreferredWidth();
    }

    private void setPreferredWidth() {
        Element element = this.component.getDocument().getDefaultRootElement();
        int n = element.getElementCount();
        int n2 = Math.max(String.valueOf(n).length(), this.minimumDisplayDigits);
        if (this.lastDigits != n2) {
            this.lastDigits = n2;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = fontMetrics.charWidth('0') * n2;
            Insets insets = this.getInsets();
            int n4 = insets.left + insets.right + n3;
            Dimension dimension = this.getPreferredSize();
            dimension.setSize(n4, 2146483647);
            this.setPreferredSize(dimension);
            this.setSize(dimension);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
        Insets insets = this.getInsets();
        int n = this.getSize().width - insets.left - insets.right;
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = this.component.viewToModel2D(new Point(0, rectangle.y));
        int n3 = this.component.viewToModel2D(new Point(0, rectangle.y + rectangle.height));
        while (n2 <= n3) {
            try {
                if (this.isCurrentLine(n2)) {
                    graphics.setColor(this.getCurrentLineForeground());
                } else {
                    graphics.setColor(this.getForeground());
                }
                String string = this.getTextLineNumber(n2);
                int n4 = fontMetrics.stringWidth(string);
                int n5 = this.getOffsetX(n, n4) + insets.left;
                int n6 = this.getOffsetY(n2, fontMetrics);
                graphics.drawString(string, n5, n6);
                n2 = Utilities.getRowEnd(this.component, n2) + 1;
            }
            catch (Exception exception) {
                break;
            }
        }
    }

    private boolean isCurrentLine(int n) {
        int n2 = this.component.getCaretPosition();
        Element element = this.component.getDocument().getDefaultRootElement();
        return element.getElementIndex(n) == element.getElementIndex(n2);
    }

    protected String getTextLineNumber(int n) {
        int n2;
        Element element = this.component.getDocument().getDefaultRootElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (element2.getStartOffset() == n) {
            return String.valueOf(n2 + 1);
        }
        return "";
    }

    private int getOffsetX(int n, int n2) {
        return (int)((float)(n - n2) * this.digitAlignment);
    }

    private int getOffsetY(int n, FontMetrics fontMetrics) throws BadLocationException {
        Rectangle rectangle = new Rectangle(this.component.modelToView2D(n).getBounds());
        int n2 = fontMetrics.getHeight();
        int n3 = rectangle.y + rectangle.height;
        int n4 = 0;
        if (rectangle.height == n2) {
            n4 = fontMetrics.getDescent();
        } else {
            if (this.fonts == null) {
                this.fonts = new HashMap();
            }
            Element element = this.component.getDocument().getDefaultRootElement();
            int n5 = element.getElementIndex(n);
            Element element2 = element.getElement(n5);
            for (int i = 0; i < element2.getElementCount(); ++i) {
                Integer n6;
                Element element3 = element2.getElement(i);
                AttributeSet attributeSet = element3.getAttributes();
                String string = (String)attributeSet.getAttribute(StyleConstants.FontFamily);
                String string2 = string + (n6 = (Integer)attributeSet.getAttribute(StyleConstants.FontSize));
                FontMetrics fontMetrics2 = this.fonts.get(string2);
                if (fontMetrics2 == null) {
                    Font font = new Font(string, 0, n6);
                    fontMetrics2 = this.component.getFontMetrics(font);
                    this.fonts.put(string2, fontMetrics2);
                }
                n4 = Math.max(n4, fontMetrics2.getDescent());
            }
        }
        return n3 - n4;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.component.getCaretPosition();
        Element element = this.component.getDocument().getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        if (this.lastLine != n2) {
            this.repaint();
            this.lastLine = n2;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    private void documentChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int n = TextLineNumber.this.component.getDocument().getLength();
                    Rectangle rectangle = new Rectangle(TextLineNumber.this.component.modelToView2D(n).getBounds());
                    if (rectangle != null && rectangle.y != TextLineNumber.this.lastHeight) {
                        TextLineNumber.this.setPreferredWidth();
                        TextLineNumber.this.repaint();
                        TextLineNumber.this.lastHeight = rectangle.y;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof Font) {
            Font font = (Font)object;
            if (this.updateFont) {
                this.setFont(font);
                this.lastDigits = 0;
                this.setPreferredWidth();
            } else {
                this.repaint();
            }
        }
    }
}

