/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.pictures;

import de.duehl.swing.ui.elements.pictures.MouseWheelReactor;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class PicturePanelHelper {
    public static MouseWheelListener createMouseWheelListener(final MouseWheelReactor mouseWheelReactor) {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                if (n < 0) {
                    mouseWheelReactor.mouseWheelUp(-n);
                } else {
                    mouseWheelReactor.mouseWheelDown(n);
                }
            }
        };
    }

    public static MouseWheelListener createVerbooseMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n = mouseWheelEvent.getWheelRotation();
                String string = n < 0 ? "Mouse wheel moved UP " + -n + " notch(es)" : "Mouse wheel moved DOWN " + n + " notch(es)";
                if (mouseWheelEvent.getScrollType() == 0) {
                    string = string + "    Scroll type: WHEEL_UNIT_SCROLL\n";
                    string = string + "    Scroll amount: " + mouseWheelEvent.getScrollAmount() + " unit increments per notch\n";
                    string = string + "    Units to scroll: " + mouseWheelEvent.getUnitsToScroll() + " unit increments\n";
                } else {
                    string = string + "    Scroll type: WHEEL_BLOCK_SCROLL";
                }
                System.out.println(string);
            }
        };
    }
}

