/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.progress;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.progress.ColoredProgressPanel;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class StandardColoredProgressPanel {
    private static final boolean DEBUG = false;
    private String progressTitle = "";
    private String countPrefix = "";
    private String timerPrefix = "";
    private String actualElementPrefix = "";
    private String actualElementPrefixBeforeStart = "";
    private String actualElementWhenDone = "";
    private ColoredProgressPanel progressPanel;
    private int numberOfTasksToDo = -1;
    private int numberOfTasksDone = 0;

    public StandardColoredProgressPanel setProgressTitle(String string) {
        this.checkProgressBarIsNull("setProgressTitle()");
        this.progressTitle = string;
        return this;
    }

    public StandardColoredProgressPanel setCountPrefix(String string) {
        this.checkProgressBarIsNull("setCountPrefix()");
        this.countPrefix = string;
        return this;
    }

    public StandardColoredProgressPanel setTimerPrefix(String string) {
        this.checkProgressBarIsNull("setTimerPrefix()");
        this.timerPrefix = string;
        return this;
    }

    public StandardColoredProgressPanel setActualElementPrefix(String string) {
        this.checkProgressBarIsNull("setActualElementPrefix()");
        this.actualElementPrefix = string;
        return this;
    }

    public StandardColoredProgressPanel setActualElementPrefixBeforeStart(String string) {
        this.checkProgressBarIsNull("setActualElementPrefixBeforeStart()");
        this.actualElementPrefixBeforeStart = string;
        return this;
    }

    public StandardColoredProgressPanel setActualElementWhenDone(String string) {
        this.checkProgressBarIsNull("setActualElementWhenDone()");
        this.actualElementWhenDone = string;
        return this;
    }

    private void checkProgressBarIsNull(String string) {
        if (null != this.progressPanel) {
            throw new RuntimeException(string + " darf nur vor createProgressPanel() aufgerufen werden!");
        }
    }

    public StandardColoredProgressPanel createProgressPanel() {
        this.progressPanel = new ColoredProgressPanel(this.progressTitle, this.countPrefix, this.timerPrefix, this.actualElementPrefix, this.actualElementPrefixBeforeStart, this.actualElementWhenDone);
        this.progressPanel.stopStopWatch();
        GuiTools.createTitle(this.progressPanel);
        return this;
    }

    private void checkProgressBarIsInitialized(String string) {
        if (null == this.progressPanel) {
            throw new RuntimeException(string + " darf erst nach createProgressPanel() aufgerufen werden!");
        }
    }

    public void initNumberOfTasksToDo(int n) {
        SwingUtilities.invokeLater(() -> this.initNumberOfTasksToDoInEdt(n));
    }

    private void initNumberOfTasksToDoInEdt(int n) {
        this.numberOfTasksToDo = n;
        StandardColoredProgressPanel.say("initNumberOfTasksToDoInEdt: numberOfTasksToDo = " + n);
        this.checkProgressBarIsInitialized("initNumberOfTasksToDo()");
        this.progressPanel.updateProgress(n, this.numberOfTasksDone, "noch nicht angefangen");
    }

    public Component getComponent() {
        this.checkProgressBarIsInitialized("getComponent()");
        return this.progressPanel;
    }

    public void startingWithTask() {
        SwingUtilities.invokeLater(() -> this.startingWithTaskInEdt());
    }

    private void startingWithTaskInEdt() {
        this.checkProgressBarIsInitialized("startingWithTask()");
        this.numberOfTasksDone = 0;
        this.updateProgress(this.actualElementPrefixBeforeStart);
        StandardColoredProgressPanel.say("updateProgress: START");
        this.progressPanel.startStopWatch();
    }

    public void aboutToExceuteOneTaskSoon(String string) {
        SwingUtilities.invokeLater(() -> this.aboutToExceuteOneTaskSoonInEdt(string));
    }

    private void aboutToExceuteOneTaskSoonInEdt(String string) {
        this.checkProgressBarIsInitialized("aboutToExceuteOneTaskSoon()");
        this.updateProgress(string);
    }

    public void oneTaskDone(String string) {
        SwingUtilities.invokeLater(() -> this.oneTaskDoneInEdt(string));
    }

    private void oneTaskDoneInEdt(String string) {
        this.checkProgressBarIsInitialized("oneTaskDone()");
        ++this.numberOfTasksDone;
        StandardColoredProgressPanel.say("oneTaskDoneInEdt: numberOfTasksDone = " + this.numberOfTasksDone);
        this.updateProgress(string);
    }

    private void updateProgress(String string) {
        this.checkProgressBarIsInitialized("updateProgress()");
        this.progressPanel.updateProgress(this.numberOfTasksToDo, this.numberOfTasksDone, string);
        StandardColoredProgressPanel.say("updateProgress: numberOfTasksToDo = " + this.numberOfTasksToDo + ", numberOfTasksDone = " + this.numberOfTasksDone);
    }

    public void quit() {
        SwingUtilities.invokeLater(() -> this.quitInEdt());
    }

    private void quitInEdt() {
        this.progressPanel.stopStopWatch();
    }

    private static void say(String string) {
    }
}

