/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.size;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class SizeChooser
extends ModalDialogBase {
    public static final int NO_VALUE_SELECTED = -1;
    private final int rows;
    private final int columns;
    private final List<Integer> possibleSizes;
    private int size;
    private boolean differentSizesAreOk;
    private final List<JButton> buttons;
    private final JFormattedTextField valueTextField;

    public SizeChooser(int n, String string, int n2, int n3, List<Integer> list, Point point, Image image) {
        super(point, image, string);
        this.setMinimumSize(400, 250);
        this.rows = n2;
        this.columns = n3;
        this.possibleSizes = list;
        this.size = -1;
        this.differentSizesAreOk = false;
        this.buttons = new ArrayList<JButton>();
        this.valueTextField = this.createValueTextField();
        this.fillDialog();
    }

    private JFormattedTextField createValueTextField() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setMinimumFractionDigits(0);
        JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormat);
        GuiTools.setEditFieldColors(jFormattedTextField);
        GuiTools.addReturnListener(jFormattedTextField, () -> this.valueEntered(jFormattedTextField.getText()));
        return jFormattedTextField;
    }

    public void diffenrentSizesAreOk() {
        this.differentSizesAreOk = true;
    }

    @Override
    protected void populateDialog() {
        this.add(this.createNumberButtonsPart(), "Center");
        this.add(this.createEnterValuePart(), "South");
    }

    private Component createNumberButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(this.rows, this.columns));
        for (int n : this.possibleSizes) {
            JButton jButton = new JButton(Integer.toString(n));
            jButton.addActionListener(actionEvent -> this.valueEntered(n));
            this.buttons.add(jButton);
            jPanel.add(jButton);
        }
        return jPanel;
    }

    private Component createEnterValuePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.valueTextField, "Center");
        return jPanel;
    }

    private void valueEntered(String string) {
        int n = NumberString.parseIntIgnore(string, -1);
        this.valueEntered(n);
    }

    private void valueEntered(int n) {
        if (this.differentSizesAreOk || this.possibleSizes.contains(n)) {
            this.size = n;
            this.closeDialog();
        } else {
            GuiTools.beep();
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
        String string = Integer.toString(n);
        boolean bl = false;
        for (JButton jButton : this.buttons) {
            String string2 = jButton.getText();
            if (!string.equals(string2)) continue;
            jButton.requestFocusInWindow();
            bl = true;
            break;
        }
        if (!bl) {
            this.valueTextField.setText(string);
            this.valueTextField.requestFocusInWindow();
        }
    }
}

