/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.filter.method;

import de.duehl.swing.ui.filter.exceptions.FilterException;
import de.duehl.swing.ui.filter.method.Method;
import de.duehl.swing.ui.filter.method.combination.CombinationElement;
import de.duehl.swing.ui.filter.method.combination.CombinationElementList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodCombination<Data>
implements Method<Data> {
    private CombinationElementList<Data> elements;

    public MethodCombination(CombinationElementList<Data> combinationElementList) {
        this.elements = combinationElementList;
        if (0 == combinationElementList.size()) {
            throw new FilterException("Leere Listen sind nicht erlaubt!");
        }
    }

    @Override
    public List<Integer> buildFilter(List<Data> list) {
        ArrayList<ElementOrList> arrayList = new ArrayList<ElementOrList>();
        for (CombinationElement<Data> combinationElement : this.elements) {
            ElementOrList elementOrList;
            if (combinationElement.isMethod()) {
                Method<Data> method = combinationElement.getMethod();
                List<Integer> list2 = this.createListByMethod(method, list);
                elementOrList = new ElementOrList(list2);
            } else {
                elementOrList = new ElementOrList(combinationElement);
            }
            arrayList.add(elementOrList);
        }
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            arrayList2.add(i + 1);
        }
        this.workOnElementsOrLists(arrayList, arrayList2);
        if (arrayList.size() != 1) {
            throw new FilterException("Nach rekursiver Bearbeitung ist nicht genau ein ElementOrList-Objekt \u00fcbriggeblieben.");
        }
        if (!((ElementOrList)arrayList.get(0)).isList()) {
            throw new FilterException("Nach rekursiver Bearbeitung ist genau ein ElementOrList-Objekt\n\u00fcbriggeblieben, aber dieses ist keine Liste!");
        }
        return ((ElementOrList)arrayList.get(0)).getList();
    }

    private void workOnElementsOrLists(List<ElementOrList> list, List<Integer> list2) {
        CombinationElement combinationElement;
        ElementOrList elementOrList;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            elementOrList = list.get(i);
            if (elementOrList.isList) continue;
            combinationElement = elementOrList.getElement();
            if (combinationElement.isOpeningBrace()) {
                n = i;
                continue;
            }
            if (!combinationElement.isClosingBrace() || -1 == n) continue;
            n2 = i;
            break;
        }
        if (-1 != n && -1 == n2) {
            throw new FilterException("Fehler im Aufbau der Methodenkombinierung, \u00f6ffnende\nKlammer ohne passende schlie\u00dfende Klammer gefunden.");
        }
        if (-1 == n && -1 != n2) {
            throw new FilterException("Fehler im Aufbau der Methodenkombinierung, schlie\u00dfende\nKlammer ohne passende \u00f6ffnende Klammer gefunden.");
        }
        if (-1 != n && -1 != n2) {
            if (n2 == 1 + n) {
                throw new FilterException("Fehler im Aufbau der Methodenkombinierung, Klammerpaar\nohne Inhalt gefunden.");
            }
            ArrayList<ElementOrList> arrayList = new ArrayList<ElementOrList>();
            for (int i = n + 1; i < n2; ++i) {
                arrayList.add(list.get(i));
            }
            List<Integer> list3 = this.workOnElementsWithoutBraces(arrayList, list2);
            combinationElement = new ElementOrList(list3);
            ArrayList<ElementOrList> arrayList2 = new ArrayList<ElementOrList>();
            for (int i = 0; i < n; ++i) {
                arrayList2.add(list.get(i));
            }
            ArrayList<ElementOrList> arrayList3 = new ArrayList<ElementOrList>();
            for (int i = n2 + 1; i < list.size(); ++i) {
                arrayList3.add(list.get(i));
            }
            list.clear();
            for (ElementOrList elementOrList2 : arrayList2) {
                list.add(elementOrList2);
            }
            list.add((ElementOrList)((Object)combinationElement));
            for (ElementOrList elementOrList2 : arrayList3) {
                list.add(elementOrList2);
            }
            this.workOnElementsOrLists(list, list2);
        } else {
            List<Integer> list4 = this.workOnElementsWithoutBraces(list, list2);
            elementOrList = new ElementOrList(list4);
            list.clear();
            list.add(elementOrList);
        }
    }

    private List<Integer> workOnElementsWithoutBraces(List<ElementOrList> list, List<Integer> list2) {
        while (1 < list.size()) {
            Object object;
            List<Integer> list3;
            Object object2;
            ElementOrList elementOrList;
            int n;
            for (n = list.size() - 1; n >= 0 && list.get(n).isList(); --n) {
            }
            if (n < 0) {
                throw new FilterException("Liste mit mehr als einem Element, aber kein Operator gefunden.");
            }
            if (n == list.size() - 1) {
                throw new FilterException("Letztes Element ist ein Operator.");
            }
            CombinationElement combinationElement = list.get(n).getElement();
            if (combinationElement.isIntersection() || combinationElement.isUnion()) {
                if (n + 2 >= list.size()) {
                    throw new FilterException("Zu wenige Parameter f\u00fcr eine zweistellige Operation.");
                }
                elementOrList = list.get(n + 1);
                object2 = list.get(n + 2);
                list3 = elementOrList.getList();
                object = ((ElementOrList)object2).getList();
                List<Integer> list4 = combinationElement.isIntersection() ? MethodCombination.intersectLists(list3, object) : MethodCombination.uniteLists(list3, object);
                list.remove(n + 2);
                list.remove(n + 1);
                ElementOrList elementOrList2 = new ElementOrList(list4);
                list.set(n, elementOrList2);
                continue;
            }
            if (combinationElement.isNegation()) {
                elementOrList = list.get(n + 1);
                object2 = elementOrList.getList();
                list3 = MethodCombination.negateList(object2, list2);
                list.remove(n + 1);
                object = new ElementOrList(list3);
                list.set(n, (ElementOrList)object);
                continue;
            }
            throw new FilterException("Unbekannter Operator.");
        }
        ElementOrList elementOrList = list.get(0);
        if (!elementOrList.isList()) {
            throw new FilterException("Bei rekursiver Bearbeitung ist genau ein ElementOrList-Objekt\n\u00fcbriggeblieben, aber dieses ist keine Liste!");
        }
        return elementOrList.getList();
    }

    static List<Integer> negateList(List<Integer> list, List<Integer> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n : list2) {
            if (list.contains(n)) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    static List<Integer> intersectLists(List<Integer> list, List<Integer> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n : list) {
            if (!list2.contains(n)) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    static List<Integer> uniteLists(List<Integer> list, List<Integer> list2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(list);
        for (Integer n : list2) {
            if (list.contains(n)) continue;
            arrayList.add(n);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private List<Integer> createListByMethod(Method<Data> method, List<Data> list) {
        return method.buildFilter(list);
    }

    private class ElementOrList {
        private final boolean isList;
        private final List<Integer> list;
        private final CombinationElement<Data> element;

        public ElementOrList(List<Integer> list) {
            this.isList = true;
            this.list = list;
            this.element = null;
        }

        public ElementOrList(CombinationElement<Data> combinationElement) {
            this.isList = false;
            this.list = null;
            this.element = combinationElement;
        }

        public boolean isList() {
            return this.isList;
        }

        public List<Integer> getList() throws FilterException {
            if (!this.isList) {
                throw new FilterException("ElementOrList enth\u00e4lt ein Element, man will aber die Liste.");
            }
            return this.list;
        }

        public CombinationElement<Data> getElement() throws FilterException {
            if (this.isList) {
                throw new FilterException("ElementOrList enth\u00e4lt eine Liste, man will aber das Element.");
            }
            return this.element;
        }
    }
}

