/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.handler.error;

import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.error.ErrorDialog;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SimpleErrorHandler
implements ErrorHandler {
    private final Image programImage;
    private final JFrame parentFrame;

    public SimpleErrorHandler() {
        this(null, null);
    }

    public SimpleErrorHandler(Image image, JFrame jFrame) {
        this.programImage = image;
        this.parentFrame = jFrame;
    }

    @Override
    public void warning(String string) {
        SwingUtilities.invokeLater(() -> this.warningInEDT(string));
    }

    private void warningInEDT(String string) {
        String string2 = Text.addLineBreaks(string, 80);
        JOptionPane.showMessageDialog(this.parentFrame, string2, "Warnung", 2);
    }

    @Override
    public void error(String string) {
        this.error(string, null);
    }

    @Override
    public void error(String string, Exception exception) {
        ErrorDialog errorDialog = new ErrorDialog(string, exception, this.programImage, this.calculateLocation());
        SwingUtilities.invokeLater(() -> this.errorInEDT(errorDialog));
    }

    private void errorInEDT(ErrorDialog errorDialog) {
        errorDialog.setVisible(true);
    }

    private Point calculateLocation() {
        if (this.parentFrame == null) {
            return new Point(400, 150);
        }
        return this.parentFrame.getLocation();
    }
}

