/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.pages;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.navigator.list.ListNavigator;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.pages.PanelFromDataCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DatasetsOnPages<DataType> {
    private static final List<Integer> POSSIBLE_DATASETS_ON_PAGE_VALUES = CollectionsHelper.buildListFrom(10, 15, 20, 25, 30, 35, 40, 45, 50, 60, 70, 80, 90, 100);
    private static final List<Integer> POSSIBLE_COLUMNS = CollectionsHelper.buildListFrom(1, 2, 3, 4, 5);
    private List<DataType> datasets;
    private final PanelFromDataCreator<DataType> panelFromDatasetCreator;
    private int numberOfDatasetsPerPage;
    private int numberOfColumns;
    private final JPanel panel;
    private final JComboBox<Integer> numberOfDatasetsPerPageComboBox;
    private final JComboBox<Integer> numberOfColumnsComboBox;
    private final Map<DataType, Component> createdComponentsCache;
    private final ListNavigator<List<DataType>> navigator;
    private final JPanel pageContentPanel;
    private final JScrollPane pageContentScroll;
    private JPanel ownExtensionPanel;

    public DatasetsOnPages(List<DataType> list, PanelFromDataCreator<DataType> panelFromDataCreator, int n, int n2) {
        this.datasets = list;
        this.panelFromDatasetCreator = panelFromDataCreator;
        this.numberOfDatasetsPerPage = n;
        this.numberOfColumns = n2;
        this.panel = new JPanel();
        this.numberOfDatasetsPerPageComboBox = new JComboBox();
        this.numberOfColumnsComboBox = new JComboBox();
        this.createdComponentsCache = new HashMap<DataType, Component>();
        this.navigator = new ListNavigator();
        this.pageContentPanel = new JPanel();
        this.pageContentScroll = new JScrollPane(this.pageContentPanel);
        this.ownExtensionPanel = new JPanel();
        this.checkList();
        this.init();
        this.fillPanel();
        this.showFirstPage();
    }

    public void setOtherDatasets(List<DataType> list) {
        this.datasets = list;
        this.checkList();
        this.showFirstPage();
    }

    public void addOwnExtension(Component component) {
        this.ownExtensionPanel.add(component, "Center");
        this.panel.repaint();
    }

    private void checkList() {
        if (this.datasets.isEmpty()) {
            throw new RuntimeException("Die Liste mit den Datens\u00e4tzen ist leer.");
        }
    }

    private void init() {
        this.initPanels();
        this.initPageContentPanel();
        this.initComboBoxes();
        this.initNavigator();
        this.initScroll();
    }

    private void initPanels() {
        this.panel.setLayout(new BorderLayout());
        this.ownExtensionPanel.setLayout(new BorderLayout());
    }

    private void initPageContentPanel() {
        this.pageContentPanel.setLayout(new GridLayout(1, 0, 5, 5));
    }

    private void initComboBoxes() {
        this.initNumberOfDatasetsPerSideComboBox();
        this.initNumberOfColumnsComboBox();
    }

    private void initNumberOfDatasetsPerSideComboBox() {
        this.numberOfDatasetsPerPageComboBox.setAlignmentX(0.0f);
        this.numberOfDatasetsPerPageComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.numberOfDatasetsPerPageComboBox.getRenderer())).setHorizontalAlignment(4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(POSSIBLE_DATASETS_ON_PAGE_VALUES);
        if (!POSSIBLE_DATASETS_ON_PAGE_VALUES.contains(this.numberOfDatasetsPerPage)) {
            arrayList.add(this.numberOfDatasetsPerPage);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.numberOfDatasetsPerPageComboBox.addItem(n);
        }
        this.numberOfDatasetsPerPageComboBox.setSelectedItem(this.numberOfDatasetsPerPage);
        this.numberOfDatasetsPerPageComboBox.addActionListener(actionEvent -> this.rearrangePageAfterChangedNumbers());
    }

    private void initNumberOfColumnsComboBox() {
        this.numberOfColumnsComboBox.setAlignmentX(0.0f);
        this.numberOfColumnsComboBox.setAlignmentY(0.0f);
        ((JLabel)((Object)this.numberOfColumnsComboBox.getRenderer())).setHorizontalAlignment(4);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(POSSIBLE_COLUMNS);
        if (!POSSIBLE_COLUMNS.contains(this.numberOfColumns)) {
            arrayList.add(this.numberOfColumns);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.numberOfColumnsComboBox.addItem(n);
        }
        this.numberOfColumnsComboBox.setSelectedItem(this.numberOfColumns);
        this.numberOfColumnsComboBox.addActionListener(actionEvent -> this.rearrangePageAfterChangedNumbers());
    }

    private void rearrangePageAfterChangedNumbers() {
        int n;
        this.numberOfDatasetsPerPage = (Integer)this.numberOfDatasetsPerPageComboBox.getSelectedItem();
        this.numberOfColumns = (Integer)this.numberOfColumnsComboBox.getSelectedItem();
        List<DataType> list = this.navigator.getActualDataSet();
        if (list.isEmpty()) {
            n = 1;
        } else {
            DataType DataType = list.get(0);
            this.navigator.setDataListWithoutShowingFirstElement(this.createPagesDatasetLists());
            List<List<DataType>> list2 = this.navigator.getAllDatasets();
            int n2 = -1;
            for (int i = 0; i < list2.size(); ++i) {
                List<DataType> list3 = list2.get(i);
                if (!list3.contains(DataType)) continue;
                n2 = i;
                break;
            }
            n = n2 + 1;
        }
        this.navigator.goToNumber(n);
    }

    private void initNavigator() {
        this.navigator.setShowMethod(list -> this.showDatasetsOnPage((List<DataType>)list));
    }

    private void initScroll() {
        GuiTools.setVerticalScrollBarUnitIncrement(this.pageContentScroll, 30);
    }

    private void fillPanel() {
        this.panel.add(this.createUpperNumbersPart(), "North");
        this.panel.add((Component)this.pageContentScroll, "Center");
        this.panel.add(this.createNavigatorPart(), "South");
    }

    private Component createUpperNumbersPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createNumberOfDatasetsPerPageComboBoxWithTitelPart(), "West");
        jPanel.add((Component)GuiTools.centerHorizontal(this.ownExtensionPanel), "Center");
        jPanel.add(this.createNumberOfColumnsComboBoxWithTitelPart(), "East");
        return jPanel;
    }

    private Component createNumberOfDatasetsPerPageComboBoxWithTitelPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Anzahl Datens\u00e4tze pro Seite "), "West");
        jPanel.add(this.numberOfDatasetsPerPageComboBox, "Center");
        return jPanel;
    }

    private Component createNumberOfColumnsComboBoxWithTitelPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Anzahl Spalten "), "West");
        jPanel.add(this.numberOfColumnsComboBox, "Center");
        return jPanel;
    }

    private Component createNavigatorPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createCenteredNavigatorPanel(), "Center");
        return jPanel;
    }

    private Component createCenteredNavigatorPanel() {
        JPanel jPanel = GuiTools.center(this.navigator.getPanel());
        return jPanel;
    }

    private void showFirstPage() {
        this.navigator.setDataList(this.createPagesDatasetLists());
    }

    private List<List<DataType>> createPagesDatasetLists() {
        int n;
        ArrayList<List<DataType>> arrayList = new ArrayList<List<DataType>>();
        int n2 = this.determineNumberOfPages();
        for (n = 1; n <= n2; ++n) {
            arrayList.add(new ArrayList());
        }
        for (n = 0; n < this.datasets.size(); ++n) {
            DataType DataType = this.datasets.get(n);
            int n3 = n / this.numberOfDatasetsPerPage;
            List list = (List)arrayList.get(n3);
            list.add(DataType);
        }
        return arrayList;
    }

    private int determineNumberOfPages() {
        int n = this.datasets.size();
        int n2 = n / this.numberOfDatasetsPerPage;
        if (n2 * this.numberOfDatasetsPerPage < n) {
            ++n2;
        }
        return n2;
    }

    private void showDatasetsOnPage(List<DataType> list) {
        int n;
        List<Component> list2 = this.createComponentsOnPage(list);
        int n2 = list2.size() / this.numberOfColumns;
        if (n2 * this.numberOfColumns < list2.size()) {
            ++n2;
        }
        ArrayList arrayList = new ArrayList();
        for (n = 1; n <= this.numberOfColumns; ++n) {
            arrayList.add(new ArrayList());
        }
        for (n = 0; n < list2.size(); ++n) {
            Component object2 = list2.get(n);
            int n3 = n / n2;
            List list3 = (List)arrayList.get(n3);
            list3.add(object2);
        }
        this.pageContentPanel.removeAll();
        for (List list4 : arrayList) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new VerticalLayout(3, 3));
            for (Component component : list4) {
                jPanel.add(component);
            }
            this.pageContentPanel.add(jPanel);
        }
        this.pageContentPanel.repaint();
        this.pageContentPanel.validate();
        this.pageContentPanel.invalidate();
        this.pageContentScroll.repaint();
        this.pageContentScroll.validate();
        this.pageContentScroll.invalidate();
        GuiTools.scrollScrollbarToMinimumLater(this.pageContentScroll);
    }

    private List<Component> createComponentsOnPage(List<DataType> list) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (DataType DataType : list) {
            Component component;
            if (this.createdComponentsCache.containsKey(DataType)) {
                component = this.createdComponentsCache.get(DataType);
            } else {
                component = this.panelFromDatasetCreator.createDatasetUi(DataType);
                this.createdComponentsCache.put(DataType, component);
            }
            arrayList.add(component);
        }
        return arrayList;
    }

    public Component getPanel() {
        return this.panel;
    }

    public int getNumberOfDatasetsPerPage() {
        return this.numberOfDatasetsPerPage;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public List<DataType> getDatasetsFromActualPage() {
        List<DataType> list = this.navigator.getActualDataSet();
        return list;
    }

    public int getActualPageNumber() {
        return this.navigator.getActualShownNumberOfElement();
    }

    public void showPage(int n) {
        int n2 = this.navigator.getNumberOfDatasets();
        if (n < 1) {
            this.navigator.goToNumber(1);
        } else if (n > n2) {
            this.navigator.goToNumber(n2);
        } else {
            this.navigator.goToNumber(n);
        }
    }
}

